/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.confirm;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.confirm.ConfirmScreen;
import plfx.screen.input.confirm.ConfirmTemplate;
import plfx.screen.input.confirm.DefaultConfirmTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultConfirmFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            CommonScreen screen;
            ConfirmTemplate template;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (ConfirmTemplate)c.newInstance("screen.pay." + path);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultConfirmTemplate("screen.pay." + path);
                }
            } else {
                template = new DefaultConfirmTemplate("screen.pay." + path);
            }
            ResourceLoader.load(Locator.getFileUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(ConfirmTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new ConfirmScreen(template);
                }
            } else {
                screen = new ConfirmScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create confirm screen: " + path, ex);
        }
    }
}

