/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.confirm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.ActionNotifier;
import plfx.model.action.VoidActionNotifier;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.confirm.ConfirmTemplate;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class ConfirmScreen
extends BaseCommonScreen {
    private final ConfirmTemplate tpl;
    private final VoidActionNotifier notifier;

    public ConfirmScreen(ConfirmTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("ConfirmTemplate");
        }
        this.tpl = tpl;
        this.notifier = new VoidActionNotifier(this);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        List fields = null;
        if (sd instanceof ConfirmScreenDescription) {
            ConfirmScreenDescription csd = (ConfirmScreenDescription)sd;
            fields = csd.getFields();
        }
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        this.tpl.initButtons(sd.getButtons());
        Collection<Object> keys = fields != null && !fields.isEmpty() ? fields : si.getModelEnvironment().getData().keySet();
        ArrayList<InputElement> comfirmed = new ArrayList<InputElement>();
        for (String string : keys) {
            InputElement ie;
            Object obj = si.getModelEnvironment().getData().get(string);
            if (!(obj instanceof InputElement) || (ie = (InputElement)obj).hasFlag(1)) continue;
            comfirmed.add(ie);
        }
        this.tpl.setConfirmed(comfirmed);
        this.notifier.init();
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }
}

