/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.communal;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.msg.LabeledMessageTemplate;
import plfx.msg.ScreenElement;
import plfx.msg.SupplierMessageTemplate;
import plfx.screen.input.communal.CommunalHelper;
import plfx.screen.input.communal.CommunalTemplate;
import plfx.screen.input.communal.CommunalTemplateListener;
import plfx.screen.pay.InputTemplateImpl;
import plfx.util.Cache;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;

public class UniCommunalTemplate
extends InputTemplateImpl
implements CommunalTemplate {
    @FXML
    private Label communalSelected;
    @FXML
    private Label communalTotal;
    @FXML
    private Label communalTotalAll;
    @FXML
    private Label communalSumAll;
    @FXML
    private Label summ;
    @FXML
    private ScrollPane communalList;
    @FXML
    private VBox communalItems;
    private SButton addAll;
    private SButton rmAll;
    private final CommunalItemCache communalItemCache = new CommunalItemCache(10);
    private List<Label> infoTitleLabels;

    public UniCommunalTemplate(String screenId, String bundleId) {
        super(screenId, bundleId);
    }

    @Override
    public void init() throws FxInitException {
        Label infL;
        super.init();
        this.addAll = this.searchButton("selectAll", true);
        this.rmAll = this.searchButton("removeAll", true);
        this.infoTitleLabels = new ArrayList<Label>();
        for (int i = 0; i < 5 && (infL = this.searchLabel("infoTitle" + i)) != null; ++i) {
            infL.setText(null);
            this.infoTitleLabels.add(infL);
        }
    }

    @Override
    public void setItems(List<Data> data, CommunalTemplateListener listener) {
        List<Data> selected;
        this.getDynamicElements().clear();
        if (this.communalTotalAll != null) {
            this.communalTotalAll.setText(Integer.toString(data.size()));
        }
        if (this.communalSumAll != null) {
            this.communalSumAll.setText(Double.toString(CommunalHelper.getSumAll(data)));
        }
        boolean isSelectAll = (selected = data.stream().filter(CommunalHelper::isSelected).collect(Collectors.toList())).size() == data.size();
        this.addAll.setListener(listener::selectAllElement);
        this.addAll.setVisible(!isSelectAll);
        this.rmAll.setListener(listener::removeAllElement);
        this.rmAll.setVisible(isSelectAll);
        this.communalItems.getChildren().clear();
        IntStream.range(0, data.size()).forEach(i -> this.communalItems.getChildren().add((Object)this.getElement((Data)data.get(i), listener, i)));
        this.communalTotal.setText(Integer.toString(selected.size()));
        double sumSelected = CommunalHelper.getSumAll(selected);
        this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)this.communalSelected, "$sf.format(" + sumSelected + ")")));
        this.communalList.setVvalue(0.0);
        this.getNextButton().setDisable(sumSelected < 1.0E-4);
    }

    private Node getElement(Data data, CommunalTemplateListener listener, int i) {
        boolean selected = CommunalHelper.isSelected(data);
        Node node = (Node)this.communalItemCache.getObject("item_" + i);
        if (selected) {
            node.getStyleClass().add((Object)"communal-item-selected");
        } else {
            node.getStyleClass().removeAll((Object[])new String[]{"communal-item-selected"});
        }
        Label label = (Label)node.lookup(".communal-item-label");
        Optional.ofNullable(label).ifPresent(l -> l.setText(CommunalHelper.getTitle(data)));
        this.processInfoLabels(node, data);
        try {
            SButton editBtn = this.searchButton(".communal-item-btn-pane", true, node);
            if (CommunalHelper.getEditable(data)) {
                editBtn.setListener(() -> listener.editElement(data));
            } else {
                editBtn.setListener(() -> {});
            }
        }
        catch (FxInitException editBtn) {
            // empty catch block
        }
        CheckBox chbox = (CheckBox)node.lookup(".communal-item-checkbox");
        chbox.setDisable(!CommunalHelper.getAllowChangeState(data));
        chbox.setSelected(selected);
        chbox.setOnAction(e -> {
            if (chbox.isSelected()) {
                listener.selectElement(data);
            } else {
                listener.removeElement(data);
            }
        });
        node.getStyleClass().add((Object)"communal-item");
        return node;
    }

    private void processInfoLabels(Node node, Data d) {
        Label infL;
        ArrayList<Label> infoLabels = new ArrayList<Label>();
        for (int i = 0; i < this.infoTitleLabels.size() && (infL = (Label)node.lookup("#info" + i)) != null; ++i) {
            infL.setText(null);
            infoLabels.add(infL);
        }
        List<String> infoIdList = CommunalHelper.getInfoIdList(d);
        int end = infoLabels.size() < infoIdList.size() ? infoLabels.size() : infoIdList.size();
        for (int i = 0; i < end; ++i) {
            InputElement ie = CommunalHelper.getValue(infoIdList.get(i), d);
            if (ie == null) continue;
            if (ie.getKeyTitle() != null && !ie.getKeyTitle().trim().isEmpty()) {
                this.infoTitleLabels.get(i).setText(ie.getKeyTitle());
            }
            ((Label)infoLabels.get(i)).setText(ie.getValueTitle() == null ? ie.getValue() : ie.getValueTitle());
        }
        Label sum = (Label)node.lookup("#summ");
        sum.setText(CommunalHelper.getSumTitle(d));
        this.getDynamicElements().add(new ScreenElement(new SupplierMessageTemplate(sum.getText(), arg_0 -> ((Label)sum).setText(arg_0))));
    }

    @Override
    public void setMessage(String msg) {
    }

    private static class CommunalItemCache
    extends Cache<Node> {
        public CommunalItemCache(int firstCount) {
            for (int i = 0; i < firstCount; ++i) {
                this.getObject("item_" + i);
            }
        }

        @Override
        protected Node load(String path) {
            try {
                return ResourceLoader.load(Locator.getUrl("/gui/skin/{name}/screen/pay/communal/charge/uni/item.fxml"), null);
            }
            catch (LoadTemplateException ex) {
                throw new RuntimeException("Can not load communalitem for InvariantCommunalTemplate", ex);
            }
        }
    }
}

