/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.communal;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import plfx.msg.LabeledMessageTemplate;
import plfx.msg.ScreenElement;
import plfx.screen.input.communal.CommunalTemplate;
import plfx.screen.input.communal.CommunalTemplateListener;
import plfx.screen.pay.InputTemplateImpl;
import plfx.util.Cache;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;

public class MeterCommunalTemplate
extends InputTemplateImpl
implements CommunalTemplate {
    @FXML
    private Label meterSum;
    @FXML
    private ScrollPane meterlList;
    @FXML
    private VBox communalItems;
    private final DecimalFormat df;
    private final CommunalItemCache communalItemCache = new CommunalItemCache(20);
    private Map<String, Data> meters;

    public MeterCommunalTemplate(String screenId, String bundleId) {
        super(screenId, bundleId);
        this.df = new DecimalFormat();
        this.df.setMaximumFractionDigits(2);
        this.df.setMinimumFractionDigits(0);
        DecimalFormatSymbols dfs = this.df.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.df.setDecimalFormatSymbols(dfs);
        this.df.setGroupingUsed(false);
    }

    @Override
    public void setItems(List<Data> data, CommunalTemplateListener listener) {
        this.getDynamicElements().clear();
        this.communalItems.getChildren().clear();
        this.meters = new HashMap<String, Data>();
        for (Data d : data) {
            String id = this.getID(d);
            this.meters.put(id, d);
        }
        this.meters.remove(null);
        for (int i = 0; i < data.size(); ++i) {
            this.communalItems.getChildren().add((Object)this.getRow(data.get(i), listener, i));
        }
        this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)this.meterSum, "$sf.format(" + this.getSumAll(data) + ")")));
        this.meterlList.setVvalue(0.0);
    }

    private Node getRow(Data data, CommunalTemplateListener listener, int i) {
        if (!this.isRef(data)) {
            Node node = (Node)this.communalItemCache.getObject("item" + i);
            node.setOnMouseClicked(e -> listener.selectElement(data));
            ((Label)node.lookup("#name")).setText(this.getName(data));
            ((Label)node.lookup("#previous")).setText(this.getPrevious(data) == null ? "-" : this.df.format(this.getPrevious(data)));
            ((Label)node.lookup("#tariff")).setText(this.df.format(this.getTariff(data)));
            ((Label)node.lookup("#summ")).setText(this.df.format(this.getSum(data)));
            Label current = (Label)node.lookup("#current");
            current.getStyleClass().clear();
            if (this.getPrevious(data) != null) {
                current.getStyleClass().add((Object)"meter-edit");
            } else {
                current.getStyleClass().add((Object)"meter-label");
            }
            current.setText(this.getCurrent(data) != null ? this.df.format(this.getCurrent(data)) : "");
            Label consumption = (Label)node.lookup("#consumption");
            consumption.getStyleClass().clear();
            consumption.getStyleClass().add((Object)"meter-edit");
            consumption.setText(this.getConsumption(data) != null ? this.df.format(this.getConsumption(data)) : "");
            return node;
        }
        Node node = (Node)this.communalItemCache.getObject("item" + i);
        ((Label)node.lookup("#name")).setText(this.getName(data));
        ((Label)node.lookup("#current")).setText("-");
        ((Label)node.lookup("#previous")).setText("-");
        ((Label)node.lookup("#tariff")).setText(this.df.format(this.getTariff(data)));
        double consump = this.calculateConsumption(data);
        double summ = consump * this.getTariff(data);
        this.setConsumption(data, consump);
        this.setSum(data, summ);
        ((Label)node.lookup("#consumption")).setText(this.df.format(consump));
        ((Label)node.lookup("#summ")).setText(this.df.format(summ));
        return node;
    }

    private String getID(Data data) {
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"id".equals(ie.getKey()) && !"#id".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                return ie.getValue();
            }
        }
        return null;
    }

    private boolean isRef(Data data) {
        boolean editable = false;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"ref".equals(ie.getKey()) && !"#ref".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                editable = true;
                break;
            }
        }
        return editable;
    }

    private double calculateConsumption(Data data) {
        String[] refs;
        double s = 0.0;
        for (String ref : refs = this.getRef(data).split(",")) {
            Data d;
            Double r;
            if (this.meters == null || (r = this.getConsumption(d = this.meters.get(ref))) == null) continue;
            s += r.doubleValue();
        }
        return s;
    }

    private String getRef(Data data) {
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"ref".equals(ie.getKey()) && !"#ref".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                return ie.getValue();
            }
        }
        return null;
    }

    private String getName(Data data) {
        String name = "";
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"name".equals(ie.getKey()) && !"#name".equals(ie.getKey())) continue;
                name = ie.getValueTitle() != null ? ie.getValueTitle() : ie.getValue();
                break;
            }
        }
        return name;
    }

    private Double getSum(Data data) {
        Double summ = 0.0;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"summ".equals(ie.getKey()) && !"#summ".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                summ = Double.parseDouble(ie.getValue());
            }
        }
        return summ;
    }

    private void setSum(Data data, double summ) {
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"summ".equals(ie.getKey()) && !"#summ".equals(ie.getKey())) continue;
                ie.setValue("" + summ);
                return;
            }
        }
    }

    private Double getCurrent(Data data) {
        Double d = null;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"current".equals(ie.getKey()) && !"#current".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                d = Double.parseDouble(ie.getValue());
            }
        }
        return d;
    }

    private Double getPrevious(Data data) {
        Double d = null;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"previous".equals(ie.getKey()) && !"#previous".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                d = Double.parseDouble(ie.getValue());
            }
        }
        return d;
    }

    private Double getConsumption(Data data) {
        Double d = null;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"consumption".equals(ie.getKey()) && !"#consumption".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                d = Double.parseDouble(ie.getValue());
            }
        }
        return d;
    }

    private void setConsumption(Data data, double summ) {
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"consumption".equals(ie.getKey()) && !"#consumption".equals(ie.getKey())) continue;
                ie.setValue("" + summ);
                return;
            }
        }
    }

    private Double getTariff(Data data) {
        Double d = 0.0;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"tariff".equals(ie.getKey()) && !"#tariff".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().isEmpty()) continue;
                d = Double.parseDouble(ie.getValue());
            }
        }
        return d;
    }

    private double getSumAll(List<Data> data) {
        double summ = 0.0;
        for (Data d : data) {
            summ += this.getSum(d).doubleValue();
        }
        return summ;
    }

    @Override
    public void setMessage(String msg) {
    }

    private static class CommunalItemCache
    extends Cache<Node> {
        public CommunalItemCache(int firstCount) {
            for (int i = 0; i < firstCount; ++i) {
                this.getObject("item_" + i);
            }
        }

        @Override
        protected Node load(String path) {
            try {
                return ResourceLoader.load(Locator.getUrl("/gui/skin/{name}/screen/pay/communal/meter/item.fxml"), null);
            }
            catch (LoadTemplateException ex) {
                throw new RuntimeException("Can not load communalitem for InvariantCommunalTemplate : " + ex.getMessage());
            }
        }
    }
}

