/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.communal;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.msg.LabeledMessageTemplate;
import plfx.msg.ScreenElement;
import plfx.screen.input.communal.CommunalTemplate;
import plfx.screen.input.communal.CommunalTemplateListener;
import plfx.screen.pay.InputTemplateImpl;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;

public class DefaultCommunalTemplate
extends InputTemplateImpl
implements CommunalTemplate {
    private GridPane notseletcted;
    private GridPane seletcted;
    private Label communalSum;
    private Label communalComm;
    private Label communalTotal;
    private Label communalMessage;
    private SButton addAll;
    private SButton rmAll;
    @FXML
    private Label communalSelected;
    @FXML
    private Label communalTotalAll;
    @FXML
    private Label communalSumAll;

    public DefaultCommunalTemplate(String screenId, String bundleId) {
        super(screenId, bundleId);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.communalSum = this.searchLabel("communalSumm");
        this.communalComm = this.searchLabel("communalComm");
        this.communalTotal = this.searchLabel("communalTotal");
        this.communalMessage = this.searchLabel("communalMessage");
        ScrollPane notseletctedContent = (ScrollPane)this.searchNode("notseletctedContent");
        this.notseletcted = new GridPane();
        this.notseletcted.getColumnConstraints().clear();
        ColumnConstraints col = new ColumnConstraints();
        col.setPercentWidth(100.0);
        this.notseletcted.getColumnConstraints().add((Object)col);
        notseletctedContent.setContent((Node)this.notseletcted);
        ScrollPane seletctedContent = (ScrollPane)this.searchNode("seletctedContent");
        this.seletcted = new GridPane();
        this.seletcted.getColumnConstraints().clear();
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(90.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(10.0);
        this.seletcted.getColumnConstraints().add((Object)col1);
        this.seletcted.getColumnConstraints().add((Object)col2);
        this.seletcted.setGridLinesVisible(true);
        seletctedContent.setContent((Node)this.seletcted);
        this.addAll = this.searchButton("selectAll", true);
        this.rmAll = this.searchButton("removeAll", true);
    }

    @Override
    public void setItems(List<Data> data, CommunalTemplateListener listener) {
        boolean isSelectAll = data.stream().filter(d -> this.isSelected((Data)d)).count() == (long)data.size();
        this.addAll.setListener(listener::selectAllElement);
        this.addAll.setVisible(!isSelectAll);
        this.rmAll.setListener(listener::removeAllElement);
        this.rmAll.setVisible(isSelectAll);
        LinkedList<Data> selected = new LinkedList<Data>();
        LinkedList notSelected = new LinkedList();
        data.stream().forEach(d -> {
            Map attrs = StoreHelper.convert((List)d.getElements());
            if (attrs.get("selected") != null && "1".equals(((InputElement)attrs.get("selected")).getValue())) {
                selected.add((Data)d);
            } else {
                notSelected.add(d);
            }
        });
        this.getDynamicElements().clear();
        this.notseletcted.getChildren().clear();
        this.notseletcted.getRowConstraints().clear();
        IntStream.range(0, notSelected.size()).forEach(i -> {
            BasketButton ns = new BasketButton(false);
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)ns.getSum(), this.formatSum((Data)notSelected.get(i)))));
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)ns.getComm(), this.formatSumComm((Data)notSelected.get(i)))));
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)ns.getTitle(), this.getName((Data)notSelected.get(i)))));
            ns.setMaxWidth(10000.0);
            ns.getStyleClass().add((Object)"notSelected");
            ns.setDisable(!this.getAllowChangeState((Data)notSelected.get(i)));
            ns.setOnMouseClicked(e -> listener.selectElement((Data)notSelected.get(i)));
            this.notseletcted.add((Node)ns, 0, i);
        });
        this.seletcted.getChildren().clear();
        this.seletcted.getRowConstraints().clear();
        IntStream.range(0, selected.size()).forEach(i -> {
            BasketButton sel = new BasketButton(this.getEditable((Data)selected.get(i)));
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)sel.getSum(), this.formatSum((Data)selected.get(i)))));
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)sel.getComm(), this.formatSumComm((Data)selected.get(i)))));
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)sel.getTitle(), this.getName((Data)selected.get(i)))));
            sel.setMaxWidth(10000.0);
            sel.getStyleClass().add((Object)"isSelected");
            sel.setDisable(!this.getEditable((Data)selected.get(i)));
            sel.setOnMouseClicked(e -> listener.selectElement((Data)selected.get(i)));
            this.seletcted.add((Node)sel, 0, i);
            Button del = new Button("X");
            del.setMaxWidth(10000.0);
            del.setMaxHeight(10000.0);
            del.setDisable(!this.getAllowChangeState((Data)selected.get(i)));
            del.setOnMouseClicked(e -> listener.removeElement((Data)selected.get(i)));
            del.getStyleClass().add((Object)"selectedDelete");
            this.seletcted.add((Node)del, 1, i);
        });
        double sumAll = this.getSumAll(selected);
        double commAll = this.getCommAll(selected);
        double total = sumAll + commAll;
        if (this.communalSum != null) {
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)this.communalSum, "$sf.format(" + sumAll + ")")));
        }
        if (this.communalComm != null) {
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)this.communalComm, "$sf.format(" + commAll + ")")));
        }
        if (this.communalTotal != null) {
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)this.communalTotal, "$sf.format(" + total + ")")));
        }
        if (this.communalSumAll != null) {
            this.getDynamicElements().add(new ScreenElement(new LabeledMessageTemplate((Labeled)this.communalSumAll, "$sf.format(" + this.getSumAll(data) + ")")));
        }
        if (this.communalSelected != null) {
            this.communalSelected.setText(Integer.toString(selected.size()));
        }
        if (this.communalTotalAll != null) {
            this.communalTotalAll.setText(Integer.toString(data.size()));
        }
    }

    private String formatSum(Data data) {
        String sum = "";
        double summ = this.getSum(data);
        if (Math.abs(0.0 - summ) > 1.0E-4) {
            sum = sum + "$sf.format(" + summ + ")";
        }
        return sum;
    }

    private String formatSumComm(Data data) {
        String sum = "";
        double summ = this.getComm(data);
        if (Math.abs(0.0 - summ) > 1.0E-4) {
            sum = sum + "$sf.format(" + summ + ")";
        }
        return sum;
    }

    private String getName(Data data) {
        String name = "";
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"name".equals(ie.getKey()) && !"title".equals(ie.getKey())) continue;
                name = ie.getValueTitle() != null ? ie.getValueTitle() : ie.getValue();
                break;
            }
        }
        return name;
    }

    private double getSumAll(List<Data> data) {
        double summ = 0.0;
        for (Data d : data) {
            summ += this.getSum(d);
        }
        return summ;
    }

    private double getCommAll(List<Data> data) {
        double summ = 0.0;
        for (Data d : data) {
            summ += this.getComm(d);
        }
        return summ;
    }

    private double getSum(Data data) {
        double summ = 0.0;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"summ".equals(ie.getKey())) continue;
                summ = Double.parseDouble(ie.getValue());
            }
        }
        return summ;
    }

    private double getComm(Data data) {
        double summ = 0.0;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"comm".equals(ie.getKey())) continue;
                summ = Double.parseDouble(ie.getValue());
            }
        }
        return summ;
    }

    private boolean getEditable(Data data) {
        boolean editable = true;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"editable".equals(ie.getKey()) || ie.getValue() == null) continue;
                editable = 0 != Integer.parseInt(ie.getValue());
                break;
            }
        }
        return editable;
    }

    private boolean getAllowChangeState(Data data) {
        boolean allow = true;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"allow-change-state".equals(ie.getKey()) || ie.getValue() == null) continue;
                allow = 0 != Integer.parseInt(ie.getValue());
                break;
            }
        }
        return allow;
    }

    @Override
    public void setMessage(String msg) {
        if (this.communalMessage != null) {
            this.communalMessage.setText(msg);
        }
    }

    private boolean isSelected(Data data) {
        Map attrs = StoreHelper.convert((List)data.getElements());
        InputElement selected = (InputElement)attrs.get("selected");
        InputElement diezSelected = (InputElement)attrs.get("#selected");
        return selected != null && "1".equals(selected.getValue()) || diezSelected != null && "1".equals(diezSelected.getValue());
    }

    private static class BasketButton
    extends GridPane {
        private final Label sum = new Label();
        private final Label title;
        private final Pane edit;
        private Label comm;

        public BasketButton(boolean editable) {
            this.sum.getStyleClass().clear();
            this.sum.getStyleClass().add((Object)"sums");
            this.sum.setPrefWidth(10000.0);
            this.title = new Label();
            this.title.getStyleClass().clear();
            this.title.getStyleClass().add((Object)"titles");
            this.title.setPrefWidth(10000.0);
            this.edit = new Pane();
            this.edit.getStyleClass().clear();
            this.edit.getStyleClass().add((Object)"edit");
            this.edit.setPrefWidth(10000.0);
            this.comm = new Label();
            this.comm.getStyleClass().clear();
            this.comm.getStyleClass().add((Object)"sums");
            this.comm.setPrefWidth(10000.0);
            RowConstraints r = new RowConstraints();
            r.setPrefHeight(60.0);
            this.getRowConstraints().add((Object)r);
            if (editable) {
                ColumnConstraints col1 = new ColumnConstraints();
                col1.setPercentWidth(45.0);
                col1.setFillWidth(true);
                ColumnConstraints col2 = new ColumnConstraints();
                col2.setPercentWidth(25.0);
                col2.setFillWidth(true);
                ColumnConstraints col3 = new ColumnConstraints();
                col2.setPercentWidth(25.0);
                col2.setFillWidth(true);
                ColumnConstraints col4 = new ColumnConstraints();
                col4.setPercentWidth(5.0);
                col4.setFillWidth(true);
                this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2, col3, col4});
                this.add((Node)this.title, 0, 0);
                this.add((Node)this.sum, 1, 0);
                this.add((Node)this.comm, 2, 0);
                this.add((Node)this.edit, 3, 0);
            } else {
                ColumnConstraints col1 = new ColumnConstraints();
                col1.setPercentWidth(50.0);
                col1.setFillWidth(true);
                ColumnConstraints col2 = new ColumnConstraints();
                col2.setPercentWidth(25.0);
                col2.setFillWidth(true);
                ColumnConstraints col3 = new ColumnConstraints();
                col3.setPercentWidth(25.0);
                col3.setFillWidth(true);
                this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2, col3});
                this.add((Node)this.title, 0, 0);
                this.add((Node)this.sum, 1, 0);
                this.add((Node)this.comm, 2, 0);
            }
        }

        public void setSum(String sum) {
            this.sum.setText(sum);
        }

        public void setTitle(String title) {
            this.title.setText(title);
        }

        public Label getSum() {
            return this.sum;
        }

        public Label getTitle() {
            return this.title;
        }

        public Label getComm() {
            return this.comm;
        }

        public void setComm(Label comm) {
            this.comm = comm;
        }
    }
}

