/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.communal;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.input.communal.CommunalScreen;
import plfx.screen.input.communal.CommunalTemplate;
import plfx.screen.input.communal.DefaultCommunalTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultCommunalFactory
implements CommonScreenFactory {
    @Override
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            CommunalTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class, String.class);
                    template = (CommunalTemplate)c.newInstance("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultCommunalTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
            } else {
                template = new DefaultCommunalTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
            }
            if (path.startsWith("@")) {
                ResourceLoader.load(Locator.getUrl("/gui/system/screen/" + path.substring(1) + "/template.fxml"), template);
            } else {
                ResourceLoader.load(Locator.getFileUrl("/gui/skin/{name}//screen/pay/" + path + "/template.fxml"), template);
            }
            template.init();
            CommonScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(CommunalTemplate.class);
                    screen = (CommonScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new CommunalScreen(template);
                }
            } else {
                screen = new CommunalScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create communal screen: " + path, ex);
        }
    }
}

