/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.communal;

import java.util.List;
import plfx.model.action.ActionNotifier;
import plfx.screen.BaseCommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.communal.CommunalActionNotifier;
import plfx.screen.input.communal.CommunalTemplate;
import plfx.screen.input.communal.CommunalTemplateListener;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.CommunalScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class CommunalScreen
extends BaseCommonScreen {
    private CommunalTemplate tpl;
    private CommunalActionNotifier notifier;

    public CommunalScreen(CommunalTemplate tpl) {
        if (tpl == null) {
            throw new NullPointerException("CommunalTemplate");
        }
        this.tpl = tpl;
        this.notifier = new CommunalActionNotifier(this);
        tpl.getBackButton().setListener(new ButtonActionListener("prev", this.notifier));
        tpl.getExitButton().setListener(new ButtonActionListener("exit", this.notifier));
        tpl.getNextButton().setListener(new ButtonActionListener("next", this.notifier));
        tpl.getActions().forEach((a, b) -> b.setListener(() -> this.notifier.notify((String)a)));
    }

    @Override
    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        Object data;
        CommunalScreenDescription csd = null;
        NestedData nested = null;
        if (sd instanceof CommunalScreenDescription) {
            csd = (CommunalScreenDescription)sd;
            data = si.getModelEnvironment().getData().get(csd.getKey());
            if (!(data instanceof List)) {
                throw new InitException("" + data + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f NestedData");
            }
        } else {
            throw new InitException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u044d\u043a\u0440\u0430\u043d\u0430");
        }
        nested = new NestedData(csd.getKey(), (List)data);
        this.tpl.setItems(nested.getData(), new LocalTemplateListener());
        this.tpl.setMessage(csd.getMessage());
        this.notifier.init();
        this.tpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.tpl.getNavigation() != null) {
            this.tpl.getNavigation().init(sd.getNavigations(), this.notifier);
        }
    }

    @Override
    public void setListener(ScreenListener listener) {
        this.notifier.setListener(listener);
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.tpl;
    }

    @Override
    protected ActionNotifier getActionNotifier() {
        return this.notifier;
    }

    private class LocalTemplateListener
    implements CommunalTemplateListener {
        private LocalTemplateListener() {
        }

        @Override
        public void selectElement(Data data) {
            CommunalScreen.this.notifier.setKey("#selected");
            CommunalScreen.this.notifier.setData(data);
            CommunalScreen.this.notifier.notify("edit");
        }

        @Override
        public void editElement(Data data) {
            CommunalScreen.this.notifier.setKey("#edit");
            CommunalScreen.this.notifier.setData(data);
            CommunalScreen.this.notifier.notify("edit");
        }

        @Override
        public void removeElement(Data data) {
            CommunalScreen.this.notifier.setKey("#removed");
            CommunalScreen.this.notifier.setData(data);
            CommunalScreen.this.notifier.notify("edit");
        }

        @Override
        public void selectAllElement() {
            CommunalScreen.this.notifier.notify("selectall");
        }

        @Override
        public void removeAllElement() {
            CommunalScreen.this.notifier.notify("removeall");
        }
    }
}

