/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.input.communal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;

public class CommunalHelper {
    public static String getTitle(Data data) {
        String name = "";
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"name".equals(ie.getKey()) && !"title".equals(ie.getKey()) && !"#name".equals(ie.getKey()) && !"#title".equals(ie.getKey())) continue;
                name = ie.getValueTitle() != null ? ie.getValueTitle() : ie.getValue();
                break;
            }
        }
        return name;
    }

    public static List<String> getInfoIdList(Data data) {
        ArrayList<String> res = new ArrayList<String>();
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                String[] split;
                if (!"#infoIds".equals(ie.getKey())) continue;
                if (ie.getValue() == null) break;
                for (String s : split = ie.getValue().split(",")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    res.add(s);
                }
            }
        }
        return res;
    }

    public static InputElement getValue(String key, Data data) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!key.equals(ie.getKey())) continue;
                return ie;
            }
        }
        return null;
    }

    public static String getSumTitle(Data data) {
        double summ = CommunalHelper.getSum(data);
        if (Math.abs(0.0 - summ) > 1.0E-4) {
            return "$sf.format(" + summ + ")";
        }
        return "$sf.format(0.0)";
    }

    public static double getSumAll(List<Data> data) {
        double summ = 0.0;
        for (Data d : data) {
            summ = CommunalHelper.round(summ + CommunalHelper.getSum(d), 2);
        }
        return summ;
    }

    public static double getSum(Data data) {
        double summ = 0.0;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"summ".equals(ie.getKey()) && !"#summ".equals(ie.getKey()) || ie.getValue() == null || ie.getValue().trim().isEmpty()) continue;
                summ = Double.parseDouble(ie.getValue());
            }
        }
        return summ;
    }

    public static boolean isSelected(Data data) {
        Map attrs = StoreHelper.convert((List)data.getElements());
        return attrs.get("selected") != null && "1".equals(((InputElement)attrs.get("selected")).getValue()) || attrs.get("#selected") != null && "1".equals(((InputElement)attrs.get("#selected")).getValue());
    }

    public static boolean getEditable(Data data) {
        boolean editable = true;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"editable".equals(ie.getKey()) && !"#editable".equals(ie.getKey()) || ie.getValue() == null) continue;
                editable = 0 != Integer.parseInt(ie.getValue());
                break;
            }
        }
        return editable;
    }

    public static boolean getAllowChangeState(Data data) {
        boolean allow = true;
        if (data != null && data.getElements() != null) {
            for (InputElement ie : data.getElements()) {
                if (!"allow-change-state".equals(ie.getKey()) && !"#allow-change-state".equals(ie.getKey()) || ie.getValue() == null) continue;
                allow = 0 != Integer.parseInt(ie.getValue());
                break;
            }
        }
        return allow;
    }

    public static double round(double value, int symbAfterDot) {
        if (symbAfterDot < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, symbAfterDot);
        long temp = Math.round(value *= (double)factor);
        return (double)temp / (double)factor;
    }
}

