/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.help;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.offer.DefaultOfferScreen;
import plfx.screen.offer.DefaultOfferTemplate;
import plfx.screen.offer.OfferScreen;
import plfx.screen.offer.OfferTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class HelpFactory {
    public static OfferScreen createHelpScreen() throws ScreenCreateException {
        try {
            OfferScreen screen;
            OfferTemplate template;
            Properties prop = Locator.readQuietly("/gui/skin/{name}//screen/help/descriptor.properties", false);
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    template = (OfferTemplate)Class.forName(controller).newInstance();
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultOfferTemplate();
                }
            } else {
                template = new DefaultOfferTemplate();
            }
            ResourceLoader.load(Locator.getFileUrl("/gui/skin/{name}//screen/help/template.fxml"), template);
            template.init();
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(OfferTemplate.class);
                    screen = (OfferScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new DefaultOfferScreen(template);
                }
            } else {
                screen = new DefaultOfferScreen(template);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            throw new ScreenCreateException("Erron on create help screen", ex);
        }
    }
}

