/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.element.FxInitException;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenFactory;
import plfx.screen.TemplateCreateException;
import plfx.screen.lang.SelectLangScreen;
import plfx.screen.lang.SelectLangScreenFactory;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.popup.dialog.DialogTemplate;
import plfx.screen.popup.dialog.DialogTemplateStore;
import plfx.screen.utility.search.SearchScreen;
import plfx.screen.utility.search.SearchScreenFactory;
import plfx.skin.Skin;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;

public class ScreenStore {
    private static final Map<String, CommonScreen> commonScreens = new HashMap<String, CommonScreen>();
    private static final Map<String, CommonSumScreen> commonSumScreens = new HashMap<String, CommonSumScreen>();
    private static final Map<String, MenuTemplate> menuTemplates = new HashMap<String, MenuTemplate>();
    private static final DialogTemplateStore dialogTemplates = new DialogTemplateStore();
    private static volatile SearchScreen searchScreen;
    private static volatile SelectLangScreen selectLangScreen;
    private static final Logger log;

    public static CommonScreen getCommonScreen(String type) throws ScreenCreateException {
        if (type == null || type.isEmpty()) {
            return null;
        }
        return ScreenStore.chainCreateCommonScreen(type, null);
    }

    public static CommonSumScreen getCommonSumScreen(String type) throws ScreenCreateException {
        if (type == null || type.isEmpty()) {
            return null;
        }
        return ScreenStore.chainCreateCommonSumScreen(type, null);
    }

    public static MenuTemplate getMenuTemplate(String type) throws TemplateCreateException {
        return ScreenStore.chainCreateMenuTemplate(type, null);
    }

    public static CommonScreen chainCreateCommonScreen(String type, String fullType) throws ScreenCreateException {
        try {
            type = ScreenFactory.getCommonScreenAlias(type);
            CommonScreen cs = commonScreens.get(Skin.getWorkSkin() + "/" + type);
            if (cs == null && (cs = ScreenFactory.createCommonScreen(type)) != null) {
                commonScreens.put(Skin.getWorkSkin() + "/" + (fullType != null ? fullType : type), cs);
            }
            if (fullType != null) {
                commonScreens.put(Skin.getWorkSkin() + "/" + fullType, cs);
            }
            return cs;
        }
        catch (ScreenCreateException scEx) {
            int index = type.lastIndexOf(47);
            if (index != type.length() && index != -1) {
                try {
                    return ScreenStore.chainCreateCommonScreen(type.substring(0, index), fullType != null ? fullType : type);
                }
                catch (ScreenCreateException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            throw scEx;
        }
    }

    public static MenuTemplate chainCreateMenuTemplate(String type, String fullType) throws TemplateCreateException {
        try {
            MenuTemplate cs = menuTemplates.get(Skin.getWorkSkin() + "/" + type);
            if (cs == null && (cs = ScreenFactory.createMenuTemplate(type)) != null) {
                menuTemplates.put(Skin.getWorkSkin() + "/" + (fullType != null ? fullType : type), cs);
            }
            if (fullType != null) {
                menuTemplates.put(Skin.getWorkSkin() + "/" + fullType, cs);
            }
            return cs;
        }
        catch (TemplateCreateException scEx) {
            int index = type.lastIndexOf(47);
            if (index != type.length() && index != -1) {
                try {
                    return ScreenStore.chainCreateMenuTemplate(type.substring(0, index), fullType != null ? fullType : type);
                }
                catch (TemplateCreateException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            throw scEx;
        }
    }

    public static CommonSumScreen chainCreateCommonSumScreen(String type, String fullType) throws ScreenCreateException {
        try {
            type = ScreenFactory.getCommonScreenAlias(type);
            CommonSumScreen cs = commonSumScreens.get(Skin.getWorkSkin() + "/" + type);
            if (cs == null && (cs = ScreenFactory.createCommonSumScreen(type)) != null) {
                commonSumScreens.put(Skin.getWorkSkin() + "/" + (fullType != null ? fullType : type), cs);
            }
            if (fullType != null) {
                commonSumScreens.put(Skin.getWorkSkin() + "/" + fullType, cs);
            }
            return cs;
        }
        catch (ScreenCreateException scEx) {
            int index = type.lastIndexOf(47);
            if (index != type.length() && index != -1) {
                try {
                    return ScreenStore.chainCreateCommonSumScreen(type.substring(0, index), fullType != null ? fullType : type);
                }
                catch (ScreenCreateException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            throw scEx;
        }
    }

    public static MenuTemplate getMenuTemplate(String type, String alternative) throws TemplateCreateException {
        if (type == null || type.isEmpty() || alternative == null || alternative.isEmpty()) {
            return null;
        }
        MenuTemplate cs = menuTemplates.get(Skin.getWorkSkin() + "/" + type);
        if (cs != null) {
            return cs;
        }
        try {
            cs = ScreenFactory.createMenuTemplate(type);
        }
        catch (Exception ex) {
            cs = ScreenFactory.createMenuTemplate(alternative);
        }
        if (cs != null) {
            menuTemplates.put(Skin.getWorkSkin() + "/" + type, cs);
        }
        return cs;
    }

    public static DialogTemplate getDialogTemplate(String path) throws FxInitException, LoadTemplateException {
        return dialogTemplates.getTemplate(Locator.processPath("/gui/skin/{name}//popup/dialog/" + path));
    }

    public static SearchScreen getSearchScreen() throws ScreenCreateException {
        if (searchScreen == null) {
            searchScreen = SearchScreenFactory.createSearchScreen();
        }
        return searchScreen;
    }

    public static SelectLangScreen getSelectLangScreen() throws ScreenCreateException {
        if (selectLangScreen == null) {
            selectLangScreen = SelectLangScreenFactory.createSelectLangScreen();
        }
        return selectLangScreen;
    }

    static {
        log = Options.GUI;
    }
}

