/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.screen.ShellCreateException;
import plfx.screen.TemplateCreateException;
import plfx.screen.menu.MenuFactory;
import plfx.screen.menu.MenuTemplate;
import plfx.screen.pay.CommonSumScreen;
import plfx.screen.pay.SumScreenFactory;
import plfx.shell.Shell;
import plfx.shell.ShellFactory;
import plfx.util.Locator;

public class ScreenFactory {
    private static final Logger log = Options.GUI;
    private static final Map<String, String> aliases = new HashMap<String, String>();

    public static String getCommonScreenAlias(String path) throws ScreenCreateException {
        if (aliases.get(path) != null) {
            log.info((Object)("Alias found: " + path));
            return aliases.get(path);
        }
        CharSequence[] parts = path.split("/");
        String newPart = aliases.get(parts[0]);
        if (newPart != null) {
            parts[0] = newPart;
        }
        return String.join((CharSequence)"/", parts);
    }

    public static Shell createShell() throws ShellCreateException {
        log.info((Object)"--------------------------------------------------------------------------------");
        log.info((Object)"Create shell");
        Properties prop = ScreenFactory.load("/shell/");
        String type = prop.getProperty("type", "Default");
        log.info((Object)("Shell type: " + type));
        try {
            String factoryName = "plfx.shell." + type + "ShellFactory";
            log.info((Object)("Factory: " + factoryName));
            Object obj = Class.forName(factoryName).newInstance();
            log.info((Object)("Loaded class: " + obj.getClass().getCanonicalName()));
            if (obj instanceof ShellFactory) {
                ShellFactory sf = (ShellFactory)obj;
                log.info((Object)"Try to create shell");
                Shell sh = sf.create(prop);
                log.info((Object)"---- Shell successfully created");
                return sh;
            }
            throw new ShellCreateException("Wrong controller type: " + obj.getClass().getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ShellCreateException("Error on creating Shell", ex);
        }
    }

    public static MenuTemplate createMenuTemplate(String path) throws TemplateCreateException {
        IllegalArgumentException inv = ScreenFactory.checkPath(path);
        if (inv != null) {
            throw new TemplateCreateException(inv);
        }
        log.info((Object)"--------------------------------------------------------------------------------");
        log.info((Object)("Create menu screen: " + path));
        Properties prop = ScreenFactory.load("/screen/menu/" + path);
        String factory = prop.getProperty("factory", "plfx.screen.menu.DefaultMenuFactory");
        try {
            log.info((Object)("Factory: " + factory));
            Object obj = Class.forName(factory).newInstance();
            if (obj instanceof MenuFactory) {
                MenuFactory sf = (MenuFactory)obj;
                MenuTemplate mt = sf.create(path, prop);
                log.info((Object)"---- MenuTemplate successfully created");
                return mt;
            }
            throw new TemplateCreateException("Wrong controller type: " + obj.getClass().getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new TemplateCreateException("Error on creating ShellFactory", ex);
        }
    }

    public static CommonScreen createCommonScreen(String path) throws ScreenCreateException {
        log.info((Object)("Try to create screen type: " + path));
        IllegalArgumentException inv = ScreenFactory.checkPath(path);
        if (inv != null) {
            throw new ScreenCreateException(inv);
        }
        String path2 = path.replace("@", "");
        path = ScreenFactory.getCommonScreenAlias(path);
        log.info((Object)"--------------------------------------------------------------------------------");
        log.info((Object)("Create common screen: " + path2));
        String screenType = ScreenFactory.extractType(path2);
        log.info((Object)("Screen type: " + screenType));
        Properties prop = ScreenFactory.load("/screen/pay/" + path2);
        String factory = prop.getProperty("factory", "plfx.screen.input." + screenType + ".Default" + ScreenFactory.getPrefix(screenType) + "Factory");
        try {
            log.info((Object)("Factory: " + factory));
            Object obj = Class.forName(factory).newInstance();
            if (obj instanceof CommonScreenFactory) {
                CommonScreenFactory sf = (CommonScreenFactory)obj;
                CommonScreen mt = sf.create(path, prop);
                log.info((Object)"---- CommonScreen successfully created");
                return mt;
            }
            throw new ScreenCreateException("Wrong controller type: " + obj.getClass().getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ScreenCreateException("Error on creating CommonScreen, type: " + path, ex);
        }
    }

    public static CommonSumScreen createCommonSumScreen(String path) throws ScreenCreateException {
        log.info((Object)("Try to create sum screen type: " + path));
        IllegalArgumentException inv = ScreenFactory.checkPath(path);
        if (inv != null) {
            throw new ScreenCreateException(inv);
        }
        if (aliases.get(path) != null) {
            path = aliases.get(path);
            log.info((Object)("Alias found: " + path));
        }
        log.info((Object)"--------------------------------------------------------------------------------");
        log.info((Object)("Create common sum screen: " + path));
        String screenType = ScreenFactory.extractType(path);
        log.info((Object)("Screen type: " + screenType));
        Properties prop = ScreenFactory.load("/screen/pay/" + path);
        String factory = prop.getProperty("factory", "plfx.screen.pay." + screenType + ".Default" + ScreenFactory.getPrefix(screenType) + "Factory");
        try {
            log.info((Object)("Factory: " + factory));
            Object obj = Class.forName(factory).newInstance();
            if (obj instanceof SumScreenFactory) {
                SumScreenFactory sf = (SumScreenFactory)obj;
                CommonSumScreen mt = sf.create(path, prop);
                log.info((Object)"---- CommonSumScreen successfully created");
                return mt;
            }
            throw new ScreenCreateException("Wrong controller type: " + obj.getClass().getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new ScreenCreateException("Error on creating CommonSumScreen, type: " + path, ex);
        }
    }

    private static Properties load(String path) {
        if (path.startsWith("@")) {
            return Locator.readQuietly("/gui/system/screen/" + path.substring(1) + "/descriptor.properties", false);
        }
        return Locator.readQuietly("/gui/skin/{name}/" + path + "/descriptor.properties", false);
    }

    private static String extractType(String path) throws ScreenCreateException {
        if (path == null || path.isEmpty()) {
            throw new ScreenCreateException("Path is not set");
        }
        int pos = path.indexOf(47);
        String type = path;
        if (pos >= 0) {
            type = path.substring(0, pos);
        }
        return type;
    }

    private static String getPrefix(String type) {
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    private static IllegalArgumentException checkPath(String path) {
        if (path == null) {
            return new IllegalArgumentException("Path is not set");
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '1' && c <= '9' || c == '/' || c == '_' || c == '@') continue;
            return new IllegalArgumentException("Wrong charachter '" + c + "' at position " + i + " on path: " + path);
        }
        if (!path.matches("@?[a-z\\d_]+(/[a-z\\d_]+)*")) {
            return new IllegalArgumentException("Path has wrong format: " + path);
        }
        return null;
    }

    static {
        aliases.put("digital", "numeric");
        aliases.put("letter", "group");
        aliases.put("sum", "cash");
    }
}

