/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import org.apache.commons.lang.StringUtils;
import plfx.adv.AdPlace;
import plfx.adv.AdvancedAdPlace;
import plfx.adv.SimpleAdPlace;
import plfx.adv.depr.Area;
import plfx.adv.depr.BorderPaneArea;
import plfx.controller.lang.Lang;
import plfx.element.ComplexSButton;
import plfx.element.CompositeLabel;
import plfx.element.CompositeSProgressIndicator;
import plfx.element.DateSLabel;
import plfx.element.FxInitException;
import plfx.element.ImageSLabel;
import plfx.element.SButton;
import plfx.element.SLabel;
import plfx.element.SProgressIndicator;
import plfx.element.SimpleCompositeLabel;
import plfx.element.SimpleSButton;
import plfx.element.SimpleSLabel;
import plfx.element.WebViewSLabel;
import plfx.msg.ScreenElement;
import plfx.msg.ScreenElementExtractor;
import plfx.screen.FxScreenTemplate;
import plfx.screen.menu.button.BaseMenuButton;
import plfx.screen.menu.button.ComplexMenuButton;
import plfx.screen.menu.button.MenuButton;
import plfx.screen.menu.button.SimpleMenuButton;
import plfx.screen.menu.button.TagComplexMenuButton;

public class BaseFxScreenTemplate
implements FxScreenTemplate {
    public static final String LANG_CHANGE_BUTTON_SELECTED = "lang-change-btn-selected";
    @FXML
    protected Pane rootPane;
    @FXML
    protected ProgressIndicator progressIndicator;
    @FXML
    protected ProgressBar progressBar;
    private List<ScreenElement> elements;
    private List<ScreenElement> dynamicElements;
    private String screenId;
    private SLabel sTimeoutLabel;
    private SProgressIndicator sProgressIndicator;
    private List<AdPlace> adPlaces;
    private String bundleId;
    private SButton nextLang;
    private SButton selectLang;
    private List<SButton> langButtons;
    private String oldstyle;
    private List<SLabel> timers;
    private List<DateSLabel> dates;
    private Map<String, SButton> actions;
    private BooleanProperty visible;

    public BaseFxScreenTemplate(String screenId, String bundleId) {
        if (screenId == null || screenId.isEmpty()) {
            throw new IllegalArgumentException("Id must be specify");
        }
        if (bundleId == null || bundleId.isEmpty()) {
            throw new IllegalArgumentException("BundleId must be specify");
        }
        this.screenId = screenId;
        this.bundleId = bundleId;
        this.elements = new ArrayList<ScreenElement>();
        this.dynamicElements = new ArrayList<ScreenElement>();
        this.adPlaces = new ArrayList<AdPlace>();
        this.actions = new HashMap<String, SButton>();
        this.visible = new SimpleBooleanProperty(false);
    }

    @Override
    public String getId() {
        return this.screenId;
    }

    @Override
    public void init() throws FxInitException {
        Label dateLabel;
        Label timerLabel;
        AdPlace a2;
        int i;
        if (this.rootPane == null) {
            throw new FxInitException("Root pane is not set");
        }
        for (i = 0; i < 10 && (a2 = this.searchAdPlace("advPane" + i)) != null; ++i) {
            this.adPlaces.add(a2);
        }
        this.elements = ScreenElementExtractor.getScreenElements((Node)this.rootPane);
        this.sTimeoutLabel = this.searchScreenLabel("timeoutLabel", true);
        this.sProgressIndicator = new CompositeSProgressIndicator(this.progressIndicator, this.progressBar);
        this.nextLang = this.searchButton("nextlang");
        this.selectLang = this.searchButton("selectlang");
        this.langButtons = this.searchButtons(".lang-change-btn");
        this.timers = new ArrayList<SLabel>();
        this.dates = new ArrayList<DateSLabel>();
        for (i = 0; i < 30 && (timerLabel = this.searchLabel("timer" + i)) != null; ++i) {
            this.timers.add(new SimpleSLabel(timerLabel));
        }
        for (i = 0; i < 30 && (dateLabel = this.searchLabel("date" + i)) != null; ++i) {
            this.dates.add(new DateSLabel(dateLabel, dateLabel.getText()));
        }
        this.rootPane.lookupAll(".action").stream().filter(a -> a.getId() != null && !a.getId().isEmpty()).forEach(a -> {
            SButton button = null;
            if (a instanceof Button) {
                button = new SimpleSButton((Button)a);
            } else if (a instanceof Pane) {
                button = new ComplexSButton((Pane)a);
            }
            if (button != null) {
                this.actions.put(a.getId(), button);
            }
        });
    }

    @Override
    public List<ScreenElement> getElements() {
        ArrayList<ScreenElement> result = new ArrayList<ScreenElement>();
        if (this.elements != null) {
            result.addAll(this.elements);
        }
        if (this.dynamicElements != null) {
            result.addAll(this.dynamicElements);
        }
        return result;
    }

    @Override
    public List<ScreenElement> getDynamicElements() {
        return this.dynamicElements;
    }

    @Override
    public List<AdPlace> getAdPlaces() {
        return this.adPlaces;
    }

    @Override
    public SLabel getTimeoutLabel() {
        return this.sTimeoutLabel;
    }

    @Override
    public SProgressIndicator getProgressIndicator() {
        return this.sProgressIndicator;
    }

    @Override
    public Pane getPane() {
        return this.rootPane;
    }

    protected SButton searchButton(String name) throws FxInitException {
        return this.searchButton(name, true);
    }

    protected SButton searchButton(String name, boolean createStub) throws FxInitException {
        return this.searchButton(name, createStub, (Node)this.rootPane);
    }

    protected SButton searchButton(String name, boolean createStub, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            if (createStub) {
                return new SimpleSButton(null);
            }
            return null;
        }
        if (node instanceof Button) {
            return new SimpleSButton((Button)node);
        }
        if (node instanceof Pane) {
            return new ComplexSButton((Pane)node);
        }
        return new SimpleSButton(null);
    }

    protected List<SButton> searchButtons(String name) throws FxInitException {
        List<Node> nodes = this.searchNodes(name);
        ArrayList<SButton> result = new ArrayList<SButton>();
        nodes.forEach(node -> {
            if (node instanceof Button) {
                result.add(new SimpleSButton((Button)node));
            } else if (node instanceof Pane) {
                result.add(new ComplexSButton((Pane)node));
            }
        });
        return result;
    }

    protected MenuButton searchMenuButton(String name, String type) throws FxInitException {
        return this.searchMenuButton(name, type, (Node)this.rootPane);
    }

    protected MenuButton searchMenuButton(String name, String type, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            return null;
        }
        if (node instanceof Pane) {
            Pane p = (Pane)node;
            BaseMenuButton cmb = p.lookup(".button-content") != null ? new TagComplexMenuButton(p, "$mu.getTitle('" + name + "')", type) : new ComplexMenuButton(p, "$mu.getTitle('" + name + "')", type);
            this.elements.add(new ScreenElement(cmb));
            return cmb;
        }
        if (node instanceof Button) {
            Button b = (Button)node;
            b.setText(name);
            SimpleMenuButton smb = new SimpleMenuButton(b, "$mu.getTitle('" + name + "')", type);
            this.elements.add(new ScreenElement(smb));
            return smb;
        }
        return null;
    }

    protected MenuButton searchDynamicMenuButton(String name, String type) throws FxInitException {
        return this.searchDynamicMenuButton(name, type, (Node)this.rootPane);
    }

    protected MenuButton searchDynamicMenuButton(String name, String type, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            return null;
        }
        if (node instanceof Pane) {
            Pane p = (Pane)node;
            ComplexMenuButton cmb = new ComplexMenuButton(p, "$mu.getTitle('" + name + "')", type);
            return cmb;
        }
        if (node instanceof Button) {
            Button b = (Button)node;
            b.setText(name);
            SimpleMenuButton smb = new SimpleMenuButton(b, "$mu.getTitle('" + name + "')", type);
            return smb;
        }
        return null;
    }

    protected SLabel searchScreenLabel(String name, boolean createStub) throws FxInitException {
        return this.searchScreenLabel(name, createStub, (Node)this.rootPane);
    }

    protected SLabel searchScreenLabel(String name, boolean createStub, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            if (createStub) {
                return new SimpleSLabel(null);
            }
            return null;
        }
        if (node instanceof Label) {
            return new SimpleSLabel((Label)node);
        }
        if (node instanceof WebView) {
            return new WebViewSLabel((WebView)node);
        }
        if (node instanceof ImageView) {
            return new ImageSLabel((ImageView)node);
        }
        return new SimpleSLabel(null);
    }

    protected Area searchArea(String name) throws FxInitException {
        return this.searchArea(name, (Node)this.rootPane);
    }

    protected Area searchArea(String name, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            return null;
        }
        if (node instanceof BorderPane) {
            return new BorderPaneArea(name, (BorderPane)node);
        }
        return null;
    }

    protected AdPlace searchAdPlace(String name) throws FxInitException {
        return this.searchAdPlace(name, (Node)this.rootPane);
    }

    protected AdPlace searchAdPlace(String name, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            return null;
        }
        if (node instanceof StackPane) {
            StackPane sp = (StackPane)node;
            String id = this.getPlace((ObservableMap<Object, Object>)sp.getProperties());
            if (id != null && !id.isEmpty()) {
                return new AdvancedAdPlace(sp, id);
            }
            return null;
        }
        if (node instanceof Pane) {
            Pane pn = (Pane)node;
            String id = this.getPlace((ObservableMap<Object, Object>)pn.getProperties());
            if (id != null && !id.isEmpty()) {
                return new SimpleAdPlace(pn, this.getPlace((ObservableMap<Object, Object>)pn.getProperties()));
            }
            return null;
        }
        return null;
    }

    private String getPlace(ObservableMap<Object, Object> map) {
        if (map == null) {
            return null;
        }
        Object place = map.get((Object)"place");
        if (place != null && place instanceof String) {
            return (String)place;
        }
        return null;
    }

    protected CompositeLabel searchCompositeLabel(String titleName, String valueName) throws FxInitException {
        Label title = this.searchLabel(titleName);
        Label value = this.searchLabel(valueName);
        if (title != null && value != null) {
            return new SimpleCompositeLabel(title, value);
        }
        return null;
    }

    protected Label searchLabel(String name) throws FxInitException {
        return this.searchLabel(name, (Node)this.rootPane);
    }

    protected Label searchLabel(String name, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            return null;
        }
        if (node instanceof Label) {
            return (Label)node;
        }
        return null;
    }

    protected Label searchLabel(String name, boolean createStub) throws FxInitException {
        return this.searchLabel(name, (Node)this.rootPane);
    }

    protected Label searchLabel(String name, boolean createStub, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node instanceof Label) {
            return (Label)node;
        }
        if (createStub) {
            return new Label();
        }
        return null;
    }

    protected BorderPane searchBorderPane(String name) throws FxInitException {
        return this.searchBorderPane(name, (Node)this.rootPane);
    }

    protected BorderPane searchBorderPane(String name, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            return null;
        }
        if (node instanceof BorderPane) {
            return (BorderPane)node;
        }
        return null;
    }

    protected Pane searchPane(String name, boolean createStub) throws FxInitException {
        return this.searchPane(name, createStub, (Node)this.rootPane);
    }

    protected Pane searchPane(String name, boolean createStub, Node src) throws FxInitException {
        Node node = this.searchNode(name, src);
        if (node == null) {
            if (createStub) {
                return new Pane();
            }
            return null;
        }
        if (node instanceof Pane) {
            return (Pane)node;
        }
        return new Pane();
    }

    protected Node searchNode(String name) throws FxInitException {
        return this.searchNode(name, (Node)this.rootPane);
    }

    protected Node searchNode(String name, Node src) throws FxInitException {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Name is not defined");
        }
        String id = name;
        if (!name.startsWith("#") && !name.startsWith(".")) {
            id = "#" + name;
        }
        Node result = src.lookup(id);
        return result;
    }

    protected List<Node> searchNodes(String name) throws FxInitException {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Name is not defined");
        }
        String id = name;
        if (!name.startsWith("#") && !name.startsWith(".")) {
            id = "#" + name;
        }
        Set result = this.rootPane.lookupAll(id);
        return new ArrayList<Node>(result);
    }

    @Override
    public final String getDefaultBundle() {
        return this.bundleId;
    }

    @Override
    public void setLangButton(String lang, ObservableList<Lang> langs) {
        if (this.nextLang.getNode() != null) {
            if (this.oldstyle != null) {
                this.nextLang.getNode().getStyleClass().remove((Object)this.oldstyle);
            }
            this.nextLang.getNode().getStyleClass().add((Object)("lang-" + lang));
            this.oldstyle = "lang-" + lang;
        }
        if (!this.langButtons.isEmpty()) {
            this.processLangBtnsStyle(lang, langs);
        }
    }

    private void processLangBtnsStyle(String lang, ObservableList<Lang> langs) {
        for (SButton b : this.langButtons) {
            Object obj;
            b.getNode().getStyleClass().removeAll((Object[])new String[]{LANG_CHANGE_BUTTON_SELECTED});
            String language = "";
            if (b.getNode().getProperties().containsKey((Object)"lang") && (obj = b.getNode().getProperties().get((Object)"lang")) instanceof String) {
                language = (String)obj;
            }
            if (!language.isEmpty() && language.equals(lang)) {
                b.getNode().getStyleClass().add((Object)LANG_CHANGE_BUTTON_SELECTED);
            }
            if (language.isEmpty()) continue;
            Locale l = new Locale(language);
            if (!langs.contains((Object)new Lang(language, StringUtils.capitalize((String)l.getDisplayLanguage(l))))) {
                b.setDisable(true);
                continue;
            }
            b.setDisable(false);
        }
    }

    @Override
    public List<SLabel> getTimers() {
        return this.timers;
    }

    @Override
    public List<DateSLabel> getDates() {
        return this.dates;
    }

    @Override
    public SButton getNextLangButton() {
        return this.nextLang;
    }

    @Override
    public SButton getSelectLangButton() {
        return this.selectLang;
    }

    public List<SButton> getLangButtons() {
        return this.langButtons;
    }

    @Override
    public Map<String, SButton> getActions() {
        return this.actions;
    }

    @Override
    public boolean isVisible() {
        return this.visible.get();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible.set(visible);
    }

    @Override
    public ReadOnlyBooleanProperty visibleProperty() {
        return this.visible;
    }
}

