/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen;

import plfx.input.keyboard.KeyboardListener;
import plfx.model.action.ActionNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenInit;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.EventRule;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public abstract class BaseCommonScreen
implements CommonScreen {
    private ScreenDescription sd;

    @Override
    public final void init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (sd == null) {
            throw new InitException("ScreenDescription is null");
        }
        if (si == null) {
            throw new InitException("ScreenInit is null");
        }
        this.sd = sd;
        this._init(sd, si);
    }

    @Override
    public KeyboardListener getKeyboardListener() {
        return null;
    }

    @Override
    public void onEvent(Event event) {
        if (event == null) {
            throw new NullPointerException("Event is null");
        }
        if (this.sd == null || this.sd.getEventRules() == null) {
            return;
        }
        ActionNotifier an = this.getActionNotifier();
        if (an == null) {
            return;
        }
        for (EventRule er : this.sd.getEventRules()) {
            if (!event.equals((Object)er.getEvent())) continue;
            an.notify(er.getActionId());
            return;
        }
    }

    protected abstract ActionNotifier getActionNotifier();

    protected abstract void _init(ScreenDescription var1, ScreenInit var2) throws InitException;
}

