/*
 * Decompiled with CFR 0.152.
 */
package plfx.navigation;

import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import plfx.element.SimpleSButton;
import plfx.model.action.ActionNotifier;
import plfx.navigation.GuiNavigation;
import plfx.screen.pay.ButtonActionListener;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ButtonInit;

public class DefaultNavigation
implements GuiNavigation {
    @FXML
    private BorderPane navigationRoot;

    @Override
    public void init(Map<String, ButtonInit> navigations, ActionNotifier notifier) throws InitException {
        this.validate(navigations);
        if (this.navigationRoot != null && notifier != null) {
            boolean disable = false;
            HBox pane = new HBox();
            for (Map.Entry<String, ButtonInit> navi : navigations.entrySet()) {
                if (navi.getValue().isCurrent()) {
                    disable = true;
                }
                Button button = new Button();
                button.setPrefHeight(10000.0);
                button.getStyleClass().add((Object)"nbutton");
                if (navi.getValue().isCurrent()) {
                    button.getStyleClass().clear();
                    button.getStyleClass().add((Object)"nbutton");
                    button.getStyleClass().add((Object)"nbutton-current");
                }
                SimpleSButton sbutton = new SimpleSButton(button);
                sbutton.setText(navi.getValue().getName());
                sbutton.setDisable(disable);
                sbutton.setListener(new ButtonActionListener(navi.getKey(), notifier));
                pane.getChildren().add((Object)button);
            }
            this.navigationRoot.setCenter((Node)pane);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
    }

    private void validate(Map<String, ButtonInit> navigations) throws InitException {
        if (navigations == null) {
            throw new InitException("List navigation button is null");
        }
        if (navigations.size() < 2) {
            throw new InitException("Size of list navigation button is less then 2 = " + navigations.size());
        }
        long curcount = navigations.values().stream().filter(ButtonInit::isCurrent).count();
        if (curcount != 1L) {
            throw new InitException("Invalid navigation curent count = " + curcount);
        }
    }

    public String toString() {
        return "DefaultNavigation{navigationRoot=" + this.navigationRoot + '}';
    }
}

