/*
 * Decompiled with CFR 0.152.
 */
package plfx.msg.screen;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.msg.MessageProcessor;
import plfx.msg.MessageTemplate;
import plfx.msg.ScreenElement;
import plfx.msg.screen.DataExtractor;
import plfx.screen.FxScreenTemplate;

public class ScreenProcessor {
    private static DataExtractor extractor;
    private static final Logger log;

    public static void setExtractor(DataExtractor extractor) {
        ScreenProcessor.extractor = extractor;
    }

    public static void process(FxScreenTemplate fst, String bundleId) {
        if (fst == null) {
            return;
        }
        log.debug((Object)("ScreenProcessor, process: " + fst.getId()));
        fst.setLangButton(extractor.getLocale().getLanguage(), extractor.getLangs());
        List<ScreenElement> templates = fst.getElements();
        if (templates == null || templates.isEmpty()) {
            return;
        }
        MessageProcessor.process(bundleId, extractor.getLocale(), templates, extractor.getData());
    }

    public static void process(String bundleId, MessageTemplate template) {
        LinkedList<ScreenElement> templates = new LinkedList<ScreenElement>();
        templates.add(new ScreenElement(template));
        ScreenProcessor.process(bundleId, templates);
    }

    public static void process(String bundleId, List<ScreenElement> templates) {
        MessageProcessor.process(bundleId, extractor.getLocale(), templates, extractor.getData());
    }

    static {
        log = Options.DEBUG;
    }
}

