/*
 * Decompiled with CFR 0.152.
 */
package plfx.msg;

import javafx.scene.web.WebView;
import plfx.msg.MessageTemplate;

public class WebViewMessageTemplate
implements MessageTemplate {
    private WebView webView;
    private String messageId;

    public WebViewMessageTemplate(WebView webView, String messageId) {
        if (webView == null) {
            throw new NullPointerException("WebView");
        }
        if (messageId == null) {
            throw new NullPointerException("Id");
        }
        this.webView = webView;
        this.messageId = messageId;
    }

    @Override
    public String getMessageTemplate() {
        return this.messageId;
    }

    @Override
    public void setText(String text) {
        if (text.startsWith("file:")) {
            this.webView.getEngine().load(text);
        } else {
            this.webView.getEngine().loadContent(text);
        }
    }

    public String toString() {
        return "LabeledScreenMessage{labeled=" + this.webView + ", id=" + this.messageId + '}';
    }
}

