/*
 * Decompiled with CFR 0.152.
 */
package plfx.msg;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import plfx.msg.MessageTemplate;

public class SupplierMessageTemplate
implements MessageTemplate {
    private final String messageId;
    private String text;
    private Optional<Consumer<String>> resultConsumer;

    public SupplierMessageTemplate(String messageId) {
        this.messageId = Objects.requireNonNull(messageId, "Id");
    }

    public SupplierMessageTemplate(String messageId, Consumer<String> resultConsumer) {
        this.messageId = Objects.requireNonNull(messageId, "Id");
        this.resultConsumer = Optional.of(resultConsumer);
    }

    @Override
    public String getMessageTemplate() {
        return this.messageId;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        this.resultConsumer.ifPresent(c -> c.accept(text));
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return "SupplierMessageTemplate{messageId=" + this.messageId + '}';
    }
}

