/*
 * Decompiled with CFR 0.152.
 */
package plfx.msg;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.Pane;
import javafx.scene.web.WebView;
import plfx.AudioPlayerFx;
import plfx.element.WebViewHelper;
import plfx.element.scale.ScaleWrapper;
import plfx.msg.ComboBoxMessageTemplate;
import plfx.msg.DefaultDisableTemplate;
import plfx.msg.DefaultStyleClassTemplate;
import plfx.msg.DefaultStyleTemplate;
import plfx.msg.DefaultVisibleTemplate;
import plfx.msg.DisableTemplate;
import plfx.msg.LabeledMessageTemplate;
import plfx.msg.MessageTemplate;
import plfx.msg.PromptMessageTemplate;
import plfx.msg.ScreenElement;
import plfx.msg.StyleTemplate;
import plfx.msg.TabMessageTemplate;
import plfx.msg.TableColumnMessageTemplate;
import plfx.msg.VisibleTemplate;
import plfx.msg.WebViewMessageTemplate;

public class ScreenElementExtractor {
    public static List<ScreenElement> getScreenElements(Node root) {
        if (root == null) {
            return Collections.emptyList();
        }
        CopyOnWriteArrayList<ScreenElement> messages = new CopyOnWriteArrayList<ScreenElement>();
        ScreenElementExtractor.getScreenElement(root).ifPresent(messages::add);
        if (root instanceof Pane) {
            messages.addAll(((Stream)((Pane)root).getChildren().stream().unordered()).map(ScreenElementExtractor::getScreenElements).collect(CopyOnWriteArrayList::new, CopyOnWriteArrayList::addAll, CopyOnWriteArrayList::addAll));
        } else if (root instanceof ScrollPane) {
            messages.addAll(ScreenElementExtractor.getScreenElements(((ScrollPane)root).getContent()));
        } else if (root instanceof TabPane) {
            messages.addAll(((Stream)((TabPane)root).getTabs().stream().unordered()).map(ScreenElementExtractor::getScreenElement).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
            messages.addAll(((Stream)((TabPane)root).getTabs().stream().unordered()).map(Tab::getContent).map(ScreenElementExtractor::getScreenElements).collect(CopyOnWriteArrayList::new, CopyOnWriteArrayList::addAll, CopyOnWriteArrayList::addAll));
        } else if (root instanceof TableView) {
            ObservableList l = ((TableView)root).getColumns();
            messages.addAll(((Stream)l.stream().unordered()).map(ScreenElementExtractor::getScreenElement).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        }
        return messages;
    }

    private static Optional<ScreenElement> getScreenElement(Object node) {
        if (node instanceof Button) {
            ((Button)node).addEventHandler(ActionEvent.ACTION, event -> AudioPlayerFx.getInstance().play("_click.mp3"));
        }
        MessageTemplate text = ScreenElementExtractor.getMessageTpl(node);
        VisibleTemplate visible = ScreenElementExtractor.getVisibleTpl(node);
        DisableTemplate disable = ScreenElementExtractor.getDisableTpl(node);
        StyleTemplate style = ScreenElementExtractor.getStyleTpl(node);
        StyleTemplate styleClass = ScreenElementExtractor.getStyleClassTpl(node);
        ScreenElementExtractor.setScale(node);
        if (text != null || visible != null || disable != null || style != null || styleClass != null) {
            return Optional.of(new ScreenElement(text, disable, visible, style, styleClass));
        }
        return Optional.empty();
    }

    private static MessageTemplate getMessageTpl(Object node) {
        if (node instanceof TextInputControl && ScreenElementExtractor.isKey(((TextInputControl)node).getPromptText())) {
            return new PromptMessageTemplate((TextInputControl)node, ((TextInputControl)node).getPromptText().trim());
        }
        if (node instanceof Labeled && ScreenElementExtractor.isKey(((Labeled)node).getText())) {
            return new LabeledMessageTemplate((Labeled)node, ((Labeled)node).getText().trim());
        }
        if (node instanceof WebView) {
            WebView wv = (WebView)node;
            if (wv.getProperties().get((Object)"cssPath") instanceof String) {
                String cssPath = (String)wv.getProperties().get((Object)"cssPath");
                wv.getEngine().setUserStyleSheetLocation(WebViewHelper.getWebViewCssAsData(cssPath));
            } else {
                wv.getEngine().setUserStyleSheetLocation(WebViewHelper.getWebViewCssAsData());
            }
            if (ScreenElementExtractor.isKey(wv.getProperties().get((Object)"text"))) {
                return new WebViewMessageTemplate(wv, (String)wv.getProperties().get((Object)"text"));
            }
        }
        if (node instanceof TableColumn && ScreenElementExtractor.isKey(((TableColumn)node).getText())) {
            return new TableColumnMessageTemplate((TableColumn)node, ((TableColumn)node).getText().trim());
        }
        if (node instanceof Tab && ScreenElementExtractor.isKey(((Tab)node).getText())) {
            return new TabMessageTemplate((Tab)node, ((Tab)node).getText().trim());
        }
        if (node instanceof ComboBox && ScreenElementExtractor.isKey(((ComboBox)node).getProperties().get((Object)"text"))) {
            return new ComboBoxMessageTemplate((ComboBox)node, (String)((ComboBox)node).getProperties().get((Object)"text"));
        }
        return null;
    }

    private static VisibleTemplate getVisibleTpl(Object elem) {
        String val;
        Node node;
        Object prop;
        if (elem instanceof Node && (prop = (node = (Node)elem).getProperties().get((Object)"visible")) != null && prop instanceof String && !(val = (String)prop).trim().isEmpty()) {
            return new DefaultVisibleTemplate(node, val);
        }
        return null;
    }

    private static DisableTemplate getDisableTpl(Object elem) {
        String val;
        Node node;
        Object prop;
        if (elem instanceof Node && (prop = (node = (Node)elem).getProperties().get((Object)"disable")) instanceof String && !(val = (String)prop).trim().isEmpty()) {
            return new DefaultDisableTemplate(node, val);
        }
        return null;
    }

    private static StyleTemplate getStyleTpl(Object elem) {
        String val;
        Node node;
        Object prop;
        if (elem instanceof Node && (prop = (node = (Node)elem).getProperties().get((Object)"style")) instanceof String && !(val = (String)prop).trim().isEmpty()) {
            return new DefaultStyleTemplate(node, val);
        }
        return null;
    }

    private static StyleTemplate getStyleClassTpl(Object elem) {
        String val;
        Node node;
        Object prop;
        if (elem instanceof Node && (prop = (node = (Node)elem).getProperties().get((Object)"styleClass")) instanceof String && !(val = (String)prop).trim().isEmpty()) {
            return new DefaultStyleClassTemplate(node, val);
        }
        return null;
    }

    private static void setScale(Object node) {
        Labeled l;
        Object o;
        if (node instanceof Labeled && (o = (l = (Labeled)node).getProperties().get((Object)"scale")) != null) {
            ScaleWrapper.wrapLabeled(l, o.toString());
        }
    }

    public static boolean isKey(Object text) {
        return text instanceof String && (ScreenElementExtractor.isTemplate((String)text) || ((String)text).contains("$"));
    }

    public static boolean isTemplate(String name) {
        return name != null && name.trim().matches("[a-z][a-z\\d]*(_[a-z][a-z\\d]*)*");
    }

    public static boolean isPartialCondition(String condition) {
        return condition != null && !condition.contains("#if");
    }

    public static String processCondition(String condition) {
        if (ScreenElementExtractor.isPartialCondition(condition)) {
            return "#if(" + condition + ")true#{else}false#end";
        }
        return condition;
    }

    private static void getButtonCell() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

