/*
 * Decompiled with CFR 0.152.
 */
package plfx.msg;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.InvalidReferenceEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.util.introspection.Info;
import plfx.GuiNotifier;
import plfx.Options;
import plfx.msg.BundleAcceptor;
import plfx.msg.BundleData;
import plfx.msg.DisableTemplate;
import plfx.msg.MessageTemplate;
import plfx.msg.ScreenElement;
import plfx.msg.ScreenElementExtractor;
import plfx.msg.StyleTemplate;
import plfx.msg.Utf8Control;
import plfx.msg.VisibleTemplate;

public class MessageProcessor {
    public static final String BUNDLE_SKIN = "skin";
    public static final String BUNDLE_DIALOG = "dlg";
    public static final String BUNDLE_SKIN_DIALOG = "skin_dlg";
    public static final String BUNDLE_SYSTEM = "sys";
    public static final String BUNDLE_EXT = "ext";
    private static final Logger log = Options.DEBUG;
    private static final Map<String, BundleData> bundles = new HashMap<String, BundleData>();
    private static final EventCartridge ec = new EventCartridge();
    private static ResourceBundle formBundle;

    public static EventCartridge getEventCartridge() {
        return ec;
    }

    public static void setBundle(String key, String path) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key is not set");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Path is not set");
        }
        bundles.put(key, new BundleData(path, new Utf8Control()));
    }

    public static void setFormBundle(ResourceBundle formBundle) {
        MessageProcessor.formBundle = formBundle;
    }

    public static String getFormMessage(String id, String def) {
        if (formBundle != null && id != null && !id.isEmpty()) {
            try {
                return formBundle.getString(id);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return def;
    }

    public static void process(String bundleId, Locale locale, List<ScreenElement> elements, Map<String, Object> data) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        if (locale == null) {
            throw new NullPointerException("Locale is not set");
        }
        log.debug((Object)"-----------------------------------------------------------------------------------------");
        log.debug((Object)("Process, bundle id=" + bundleId + ", locale: " + locale));
        BundleData bd = bundles.get(bundleId);
        if (bd == null) {
            throw new NullPointerException("Wrong bundleId: " + bundleId);
        }
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            context.put(entry.getKey(), entry.getValue());
        }
        ResourceBundle bundle = ResourceBundle.getBundle(bd.getPath(), locale, bd.getControl());
        context.put("ba", (Object)new BundleAcceptor(bundle, context));
        ec.attachToContext((Context)context);
        for (ScreenElement se : elements) {
            StyleTemplate sct;
            StyleTemplate st;
            DisableTemplate dt;
            VisibleTemplate vt;
            MessageTemplate mt = se.getMessageTemplate();
            if (mt != null) {
                MessageProcessor.process(mt, bundleId, bundle, context);
            }
            if ((vt = se.getVisibleTemplate()) != null) {
                MessageProcessor.process(vt, bundleId, bundle, context);
            }
            if ((dt = se.getDisableTemplate()) != null) {
                MessageProcessor.process(dt, bundleId, bundle, context);
            }
            if ((st = se.getStyleTemplate()) != null) {
                MessageProcessor.process(st, bundleId, bundle, context);
            }
            if ((sct = se.getStyleClassTemplate()) == null) continue;
            MessageProcessor.process(sct, bundleId, bundle, context);
        }
        log.debug((Object)"-------------------------------------------");
    }

    private static void process(VisibleTemplate vt, String bundleId, ResourceBundle bundle, VelocityContext context) {
        String key = vt.getTemplate();
        log.debug((Object)("Process visible = " + key));
        String tpl = key;
        if (ScreenElementExtractor.isTemplate(key)) {
            try {
                tpl = bundle.getString(key);
            }
            catch (Exception ex) {
                log.error((Object)("Erron on process bundle " + bundleId), (Throwable)ex);
                MessageProcessor.notify("Wrong visible key, " + bundleId + "->" + key);
                return;
            }
        }
        try {
            StringWriter sw = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)sw, (String)"", (String)ScreenElementExtractor.processCondition(tpl));
            String result = sw.toString().trim();
            log.debug((Object)("Result: " + result));
            vt.setVisible(Boolean.parseBoolean(result));
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            log.error((Object)"Erron on process velocity", ex);
            MessageProcessor.notify("Wrong key, " + bundleId + "->" + key);
        }
    }

    private static void process(DisableTemplate dt, String bundleId, ResourceBundle bundle, VelocityContext context) {
        String key = dt.getTemplate();
        log.debug((Object)("Process disable = " + key));
        String tpl = key;
        if (ScreenElementExtractor.isTemplate(key)) {
            try {
                tpl = bundle.getString(key);
            }
            catch (Exception ex) {
                log.error((Object)("Erron on process bundle " + bundleId), (Throwable)ex);
                MessageProcessor.notify("Wrong disable key, " + bundleId + "->" + key);
                return;
            }
        }
        try {
            StringWriter sw = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)sw, (String)"", (String)ScreenElementExtractor.processCondition(tpl));
            String result = sw.toString().trim();
            log.debug((Object)("Result: " + result));
            dt.setDisable(Boolean.parseBoolean(result));
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            log.error((Object)"Erron on process velocity", ex);
            MessageProcessor.notify("Wrong key, " + bundleId + "->" + key);
        }
    }

    private static void process(StyleTemplate st, String bundleId, ResourceBundle bundle, VelocityContext context) {
        String key = st.getTemplate();
        log.debug((Object)("Process style = " + key));
        String tpl = key;
        if (ScreenElementExtractor.isTemplate(key)) {
            try {
                tpl = bundle.getString(key);
            }
            catch (Exception ex) {
                log.error((Object)("Erron on process bundle " + bundleId), (Throwable)ex);
                MessageProcessor.notify("Wrong style key, " + bundleId + "->" + key);
                return;
            }
        }
        try {
            StringWriter sw = new StringWriter();
            Velocity.evaluate((Context)context, (Writer)sw, (String)"", (String)tpl);
            String result = sw.toString().trim();
            log.debug((Object)("Result: " + result));
            st.setStyle(result);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            log.error((Object)"Erron on process velocity", ex);
            MessageProcessor.notify("Wrong key, " + bundleId + "->" + key);
        }
    }

    private static void process(MessageTemplate mt, String bundleId, ResourceBundle bundle, VelocityContext context) {
        String key = mt.getMessageTemplate();
        log.debug((Object)("Process msg = " + key));
        String tpl = key;
        if (ScreenElementExtractor.isTemplate(key)) {
            try {
                tpl = bundle.getString(key);
            }
            catch (Exception ex) {
                log.error((Object)("Erron on process bundle " + bundleId), (Throwable)ex);
                MessageProcessor.notify("Wrong key, " + bundleId + "->" + key);
                return;
            }
        }
        log.debug((Object)("Template: " + tpl));
        if (tpl.contains("$")) {
            try {
                mt.setText(MessageProcessor.processString(context, tpl));
            }
            catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
                mt.setText(MessageProcessor.processCase(tpl));
                log.error((Object)"Erron on process velocity", ex);
                MessageProcessor.notify("Wrong key, " + bundleId + "->" + mt.getMessageTemplate());
            }
        } else {
            mt.setText(MessageProcessor.processCase(tpl));
        }
    }

    public static String processString(VelocityContext context, String src) {
        StringWriter sw = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)sw, (String)"", (String)src);
        String result = sw.toString().trim();
        log.debug((Object)("Result: " + result));
        return MessageProcessor.processCase(result);
    }

    private static void notify(String template) {
        GuiNotifier.notifyProblemOnce("MessageProcessor: Error parsing screen template: " + template);
    }

    private static String processCase(String message) {
        if (message.startsWith("\u2191")) {
            return message.toUpperCase().substring(1);
        }
        if (message.startsWith("\u2193")) {
            return message.toLowerCase().substring(1);
        }
        return message;
    }

    static {
        bundles.put(BUNDLE_EXT, new BundleData("gui.system.i18n.ext", new Utf8Control()));
        bundles.put(BUNDLE_SYSTEM, new BundleData("plfx.i18n.system", new Utf8Control()));
        bundles.put(BUNDLE_DIALOG, new BundleData("gui.popup.dialog.dialog", new Utf8Control()));
        ec.addEventHandler((EventHandler)new VelocityListener());
    }

    private static class VelocityListener
    implements InvalidReferenceEventHandler {
        private VelocityListener() {
        }

        public Object invalidGetMethod(Context cntxt, String string, Object o, String string1, Info info) {
            if (!string.startsWith("$!")) {
                MessageProcessor.notify(string);
            }
            return null;
        }

        public boolean invalidSetMethod(Context cntxt, String string, String string1, Info info) {
            MessageProcessor.notify(string);
            return false;
        }

        public Object invalidMethod(Context cntxt, String string, Object o, String string1, Info info) {
            if (!string.startsWith("$!")) {
                MessageProcessor.notify(string);
            }
            return null;
        }
    }
}

