/*
 * Decompiled with CFR 0.152.
 */
package plfx.model.textfield;

import javafx.scene.control.Button;
import javafx.scene.control.Label;
import plfx.model.textfield.FieldListener;
import ru.softlogic.input.model.field.text.TextField;

public class ValidateTextFieldListener
implements FieldListener {
    private Button button;
    private Label errorLabel;
    private TextField tf;

    public ValidateTextFieldListener(Button button, Label errorLabel, TextField tf) {
        if (button == null) {
            throw new NullPointerException("ClickButton");
        }
        if (errorLabel == null) {
            throw new NullPointerException("JLabel");
        }
        if (tf == null) {
            throw new NullPointerException("TextField");
        }
        this.button = button;
        this.errorLabel = errorLabel;
        this.tf = tf;
    }

    @Override
    public void onChange(String value) {
        boolean valid = this.tf.getValidator().validate(value);
        if (!valid && this.tf.getFailRegex() != null && !this.tf.getFailRegex().isEmpty()) {
            try {
                this.button.setDisable(!value.matches(this.tf.getFailRegex()));
            }
            catch (Exception ex) {
                this.button.setDisable(true);
            }
        } else {
            this.button.setDisable(!valid);
        }
        this.errorLabel.setVisible(value.length() >= this.tf.getMaxLength() && !valid);
    }

    @Override
    public void onEnter(String value) {
    }
}

