/*
 * Decompiled with CFR 0.152.
 */
package plfx.model.textfield;

import javafx.scene.control.Button;
import javafx.scene.control.Label;
import plfx.model.textfield.FieldListener;
import ru.softlogic.input.model.field.numeric.NumericField;

public class ValidateNumericFieldListener
implements FieldListener {
    private final Button button;
    private final Label errorLabel;
    private final NumericField nf;
    private final String regex;

    public ValidateNumericFieldListener(Button button, Label errorLabel, NumericField nf) {
        if (button == null) {
            throw new NullPointerException("ClickButton");
        }
        if (errorLabel == null) {
            throw new NullPointerException("JLabel");
        }
        if (nf == null) {
            throw new NullPointerException("NumericField");
        }
        this.button = button;
        this.errorLabel = errorLabel;
        this.nf = nf;
        this.regex = nf.getDecimalCount() > 0 ? "^\\d{" + nf.getUnitCount() + "}((\\.|,)\\d{" + nf.getDecimalCount() + "})?$" : "^\\d{" + nf.getUnitCount() + "}$";
    }

    @Override
    public void onChange(String value) {
        boolean valid = this.nf.getValidator().validate(value);
        this.button.setDisable(!valid);
        this.errorLabel.setVisible(value.matches(this.regex) && !valid);
    }

    @Override
    public void onEnter(String value) {
    }
}

