/*
 * Decompiled with CFR 0.152.
 */
package plfx.model.action;

import plfx.GuiNotifier;
import plfx.model.action.ActionNotifier;
import plfx.screen.Screen;
import plfx.screen.ScreenListener;

public abstract class LockableActionNotifier
implements ActionNotifier,
Runnable {
    protected ScreenListener listener;
    private final String id;
    private final Screen screen;
    private int lock;

    public LockableActionNotifier(String id, Screen screen) {
        if (screen == null) {
            throw new NullPointerException("Screen is null");
        }
        this.id = id;
        this.screen = screen;
    }

    @Override
    public void init() {
        this.unlock();
    }

    public void setListener(ScreenListener listener) {
        this.listener = listener;
    }

    @Override
    public synchronized void notify(String type) {
        ++this.lock;
        if (this.lock == 1) {
            this._notify(type);
        } else if (this.lock > 2 && (this.lock == 3 || this.lock % 10 == 0)) {
            String addInfo = this.getAdditionalLockInfo();
            GuiNotifier.notifyError(this.id + ". Action blocked=" + type + " ,screen=" + this.screen.getClass().getCanonicalName() + ", count=" + this.lock + (addInfo != null && !addInfo.isEmpty() ? ", add=" + addInfo : ""));
            if (this.lock >= 10) {
                GuiNotifier.requestRestart("Action blocked=" + type);
            }
        }
    }

    protected synchronized void unlock() {
        this.lock = 0;
    }

    @Override
    public void run() {
        this.unlock();
    }

    protected abstract void _notify(String var1);

    protected abstract String getAdditionalLockInfo();
}

