/*
 * Decompiled with CFR 0.152.
 */
package plfx.input.keyboard.letter;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import plfx.element.FxInitException;
import plfx.input.keyboard.letter.Layout;
import plfx.util.Locator;

public class LayoutLoader {
    public static Map<String, Layout> readLayouts(String path, Properties prop) throws FxInitException {
        String propPath = prop.getProperty("layout");
        if (propPath == null || propPath.isEmpty()) {
            propPath = path;
        }
        try {
            Properties lt = Locator.read("/gui/skin/{name}/" + propPath, false);
            LinkedHashMap<String, Layout> res = new LinkedHashMap<String, Layout>();
            for (int i = 0; i < 30; ++i) {
                String code = lt.getProperty("set" + (i + 1) + ".code");
                if (code == null || code.isEmpty()) {
                    if (i >= 1) break;
                    throw new FxInitException("Key set" + (i + 1) + ".code is not found");
                }
                String layout = lt.getProperty("set" + (i + 1) + ".layout");
                if (layout == null) {
                    throw new FxInitException("Key set" + (i + 1) + ".layout is not found");
                }
                Properties p = new Properties();
                for (Map.Entry<Object, Object> entry : lt.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null || !key.toString().startsWith("set" + (i + 1))) continue;
                    p.put(key, value);
                }
                res.put("set" + (i + 1), new Layout(code, layout, p));
            }
            return res;
        }
        catch (IOException ex) {
            throw new FxInitException("Can't read layout: " + propPath, ex);
        }
    }
}

