/*
 * Decompiled with CFR 0.152.
 */
package plfx.input.keyboard.letter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutFilter {
    public static List<String> getAvailableLayouts(List<String> targetLayouts, Set<String> AvailableLayouts, String replaceRules) {
        if (targetLayouts == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> toReplace = new ArrayList<String>();
        targetLayouts.stream().forEach(name -> {
            if (AvailableLayouts.contains(name)) {
                if (!result.contains(name)) {
                    result.add((String)name);
                }
            } else {
                toReplace.add((String)name);
            }
        });
        if (replaceRules == null || replaceRules.trim().isEmpty()) {
            return result;
        }
        LayoutFilter.addFiltered(result, toReplace, LayoutFilter.parseRules(replaceRules));
        return result;
    }

    private static Map<String, List<String>> parseRules(String source) {
        String[] lts;
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (String s : lts = source.split(",")) {
            String rule;
            String[] af;
            if (!s.trim().startsWith("[") || !s.trim().endsWith("]") || (af = (rule = s.replace("[", "").replace("]", "")).split("="))[0].trim().isEmpty()) continue;
            String target = af[0].trim();
            LinkedList<String> zamens = new LinkedList<String>();
            if (af.length > 1) {
                zamens.addAll(Arrays.asList(af[1].split(":")));
            }
            result.put(target, zamens);
        }
        return result;
    }

    private static void addFiltered(List<String> source, List<String> toReplace, Map<String, List<String>> replaceRules) {
        block0: for (String name : toReplace) {
            List<String> l = replaceRules.get(name);
            if (l == null || l.isEmpty()) continue;
            for (String code : l) {
                if (source.contains(code)) continue;
                source.add(code);
                continue block0;
            }
        }
    }
}

