/*
 * Decompiled with CFR 0.152.
 */
package plfx.input.keyboard.letter;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LayoutFilter;
import plfx.input.keyboard.letter.LetterKeyboard;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;

public class DefaultLetterKeyboard
implements LetterKeyboard {
    @FXML
    private Pane keyboardPane;
    @FXML
    private Button set1Button;
    @FXML
    private Button set2Button;
    @FXML
    private Button set3Button;
    @FXML
    private Button set4Button;
    @FXML
    private Button setSymb;
    @FXML
    private Button setLang;
    @FXML
    private Button capsButton;
    @FXML
    private Button clearButton;
    @FXML
    private Button clearLastButton;
    @FXML
    private Button enterButton;
    @FXML
    private Button spaceButton;
    private List<Button> digitButtons;
    private List<Button> letterButtons;
    private Map<String, Layout> layouts;
    private List<String> keyboardLayoutNames;
    private Keyboard keyboard;
    private String currentSetName;
    private String lastSetName;
    private KeyboardCase currentCase;
    private KeyboardListener listener;
    private Map<String, Layout> langs;
    private List<Layout> availableLangs;
    private boolean symbPressed;
    private String lastStyle;
    private int n;

    public void initialize(URL location, ResourceBundle resources) {
        Node p;
        int i;
        this.digitButtons = new LinkedList<Button>();
        for (i = 0; i < 10 && (p = this.keyboardPane.lookup("#d" + i)) != null && p instanceof Button; ++i) {
            this.digitButtons.add((Button)p);
        }
        this.letterButtons = new LinkedList<Button>();
        for (i = 0; i < 50 && (p = this.keyboardPane.lookup("#let" + i)) != null && p instanceof Button; ++i) {
            this.letterButtons.add((Button)p);
        }
        Optional.ofNullable(this.capsButton).ifPresent(b -> b.setOnAction((EventHandler)new CapsActionListener()));
        Optional.ofNullable(this.setSymb).ifPresent(b -> b.setOnAction((EventHandler)new SetSymbActionListener()));
        Optional.ofNullable(this.set1Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set1", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.set2Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set2", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.set3Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set3", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.set4Button).ifPresent(b -> b.setOnAction((EventHandler)new SetActionListener("set4", "true".equals(b.getProperties().get((Object)"golast")))));
        Optional.ofNullable(this.setLang).ifPresent(b -> {
            b.setOnAction((EventHandler)new SetLangActionListener());
            b.setDisable(true);
        });
        LocalActionListener lal = new LocalActionListener();
        Optional.ofNullable(this.spaceButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.clearButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        Optional.ofNullable(this.clearLastButton).ifPresent(b -> b.setOnAction((EventHandler)lal));
        this.letterButtons.forEach(b -> b.setOnAction((EventHandler)lal));
        this.digitButtons.forEach(b -> b.setOnAction((EventHandler)lal));
    }

    @Override
    public void setLayouts(Map<String, Layout> layouts) {
        if (layouts == null) {
            throw new NullPointerException("List<Layout>");
        }
        if (layouts.size() < 1) {
            throw new NullPointerException("Layouts size is wrong: " + layouts.size());
        }
        this.layouts = layouts;
        this.availableLangs = new LinkedList<Layout>();
        this.langs = new LinkedHashMap<String, Layout>();
        layouts.values().stream().filter(l -> l.getCode().length() == 2).forEach(l -> this.langs.put(l.getCode(), (Layout)l));
    }

    @Override
    public void init(Keyboard keyboard) {
        this.keyboard = keyboard;
        Set<String> availableLayouts = this.layouts.values().stream().map(l -> l.getCode()).collect(Collectors.toSet());
        String replaceRules = this.layouts.get("set1").getProperties().getProperty("set1.replace.rules");
        this.keyboardLayoutNames = LayoutFilter.getAvailableLayouts(keyboard.getLayoutNames(), availableLayouts, replaceRules);
        boolean enable = keyboard.getType() != KeyboardType.Letter;
        this.digitButtons.stream().filter(b -> b != null).forEach(b -> b.setDisable(!enable));
        if (this.clearButton != null) {
            if (keyboard.getExtraCharacter() != null) {
                this.clearButton.setText(Character.toString(keyboard.getExtraCharacter().charValue()));
            } else {
                this.clearButton.setText("X");
            }
        }
        this.setAccessible();
        this.currentSetName = null;
        this.symbPressed = false;
        if (!this.keyboardLayoutNames.isEmpty()) {
            this.currentSetName = this.keyboardLayoutNames.get(0);
            if (this.setLang != null) {
                this.n = 0;
                if (!"symb".equals(this.currentSetName)) {
                    this.symbPressed = false;
                    this.setLang.getStyleClass().remove((Object)this.lastStyle);
                    this.lastStyle = "lang-" + this.currentSetName;
                    this.setLang.getStyleClass().add((Object)this.lastStyle);
                } else {
                    this.symbPressed = true;
                    this.setLang.getStyleClass().remove((Object)this.lastStyle);
                    if (!this.availableLangs.isEmpty()) {
                        this.lastStyle = "lang-" + this.availableLangs.get(0).getCode();
                        this.setLang.getStyleClass().add((Object)this.lastStyle);
                    } else {
                        this.lastStyle = null;
                    }
                }
            }
        }
        this.currentCase = keyboard.getDefaultCase();
        this.refreshSet();
    }

    @Override
    public void setKeyboardListener(KeyboardListener listener) {
        this.listener = listener;
    }

    private void refreshSet() {
        String currentSet = this.layouts.size() < 2 ? this.layouts.get("set1").getData() : this.layouts.get("set2").getData();
        for (Layout l : this.layouts.values()) {
            if (!l.getCode().equals(this.currentSetName)) continue;
            currentSet = l.getData();
            break;
        }
        if (currentSet != null && this.keyboard.getType() != KeyboardType.Digital) {
            for (int i = 0; i < this.letterButtons.size(); ++i) {
                Button btn2 = this.letterButtons.get(i);
                if (i < currentSet.length() && ' ' != currentSet.charAt(i)) {
                    if (this.currentCase == KeyboardCase.Lower) {
                        btn2.setText(Character.toString(Character.toLowerCase(currentSet.charAt(i))));
                    } else {
                        btn2.setText(Character.toString(Character.toUpperCase(currentSet.charAt(i))));
                    }
                    btn2.setDisable(false);
                    continue;
                }
                btn2.setText("");
                btn2.setDisable(true);
            }
        } else {
            this.letterButtons.stream().forEach(btn -> {
                btn.setText("");
                btn.setDisable(true);
            });
        }
    }

    private void setAccessible() {
        Optional.ofNullable(this.capsButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital || !this.keyboard.isAllowChangeCase()));
        Optional.ofNullable(this.spaceButton).ifPresent(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.letterButtons.stream().forEach(b -> b.setDisable(this.keyboard.getType() == KeyboardType.Digital));
        this.availableLangs.clear();
        if (this.keyboardLayoutNames != null && this.keyboardLayoutNames.size() > 1) {
            Optional.ofNullable(this.set1Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set1").getCode())));
            Optional.ofNullable(this.set2Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set2").getCode())));
            Optional.ofNullable(this.set3Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set3").getCode())));
            Optional.ofNullable(this.set4Button).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains(this.layouts.get("set4").getCode())));
            Optional.ofNullable(this.setSymb).ifPresent(b -> b.setDisable(!this.keyboardLayoutNames.contains("symb")));
            Optional.ofNullable(this.setLang).ifPresent(b -> {
                this.keyboardLayoutNames.stream().filter(name -> !"symb".equals(name)).forEach(name -> this.availableLangs.add(this.langs.get(name)));
                b.setDisable(this.availableLangs.isEmpty());
            });
        } else {
            Optional.ofNullable(this.set1Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set2Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set3Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.set4Button).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.setSymb).ifPresent(b -> b.setDisable(true));
            Optional.ofNullable(this.setLang).ifPresent(b -> b.setDisable(true));
        }
    }

    private class SetLangActionListener
    implements EventHandler<ActionEvent> {
        private SetLangActionListener() {
        }

        public void handle(ActionEvent event) {
            if (DefaultLetterKeyboard.this.symbPressed) {
                DefaultLetterKeyboard.this.currentSetName = ((Layout)DefaultLetterKeyboard.this.availableLangs.get(DefaultLetterKeyboard.this.n)).getCode();
                DefaultLetterKeyboard.this.symbPressed = false;
                DefaultLetterKeyboard.this.refreshSet();
            } else {
                DefaultLetterKeyboard.this.n = (DefaultLetterKeyboard.this.n + 1) % DefaultLetterKeyboard.this.availableLangs.size();
                DefaultLetterKeyboard.this.currentSetName = ((Layout)DefaultLetterKeyboard.this.availableLangs.get(DefaultLetterKeyboard.this.n)).getCode();
                DefaultLetterKeyboard.this.setLang.getStyleClass().remove((Object)DefaultLetterKeyboard.this.lastStyle);
                DefaultLetterKeyboard.this.setLang.getStyleClass().add((Object)("lang-" + DefaultLetterKeyboard.this.currentSetName));
                DefaultLetterKeyboard.this.lastStyle = "lang-" + DefaultLetterKeyboard.this.currentSetName;
                DefaultLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class SetSymbActionListener
    implements EventHandler<ActionEvent> {
        private String lastName;

        private SetSymbActionListener() {
        }

        public void handle(ActionEvent event) {
            if (this.lastName == null && "symb".equals(DefaultLetterKeyboard.this.currentSetName)) {
                if (!DefaultLetterKeyboard.this.availableLangs.isEmpty()) {
                    this.lastName = ((Layout)DefaultLetterKeyboard.this.availableLangs.get(0)).getCode();
                } else {
                    return;
                }
            }
            if (DefaultLetterKeyboard.this.symbPressed) {
                DefaultLetterKeyboard.this.currentSetName = this.lastName;
                DefaultLetterKeyboard.this.symbPressed = false;
                this.lastName = null;
                DefaultLetterKeyboard.this.refreshSet();
            } else {
                this.lastName = DefaultLetterKeyboard.this.currentSetName;
                DefaultLetterKeyboard.this.currentSetName = "symb";
                DefaultLetterKeyboard.this.symbPressed = true;
                DefaultLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class LocalActionListener
    implements EventHandler<ActionEvent> {
        private LocalActionListener() {
        }

        public void handle(ActionEvent e) {
            if (DefaultLetterKeyboard.this.listener != null) {
                if (e.getSource() == DefaultLetterKeyboard.this.spaceButton) {
                    DefaultLetterKeyboard.this.listener.onKeyPress(' ');
                } else if (e.getSource() == DefaultLetterKeyboard.this.clearButton) {
                    if (DefaultLetterKeyboard.this.keyboard != null && DefaultLetterKeyboard.this.keyboard.getExtraCharacter() != null) {
                        DefaultLetterKeyboard.this.listener.onKeyPress(DefaultLetterKeyboard.this.keyboard.getExtraCharacter().charValue());
                    } else {
                        DefaultLetterKeyboard.this.listener.onClear();
                    }
                } else if (e.getSource() == DefaultLetterKeyboard.this.clearLastButton) {
                    DefaultLetterKeyboard.this.listener.onClearLast();
                } else if (e.getSource() == DefaultLetterKeyboard.this.enterButton) {
                    DefaultLetterKeyboard.this.listener.onEnter();
                } else {
                    Button b = (Button)e.getSource();
                    if (b.getText() != null && !b.getText().isEmpty()) {
                        char ch = b.getText().charAt(0);
                        DefaultLetterKeyboard.this.listener.onKeyPress(ch);
                    }
                }
            }
        }
    }

    private class SetActionListener
    implements EventHandler<ActionEvent> {
        private final String setName;
        private boolean goLastSet = true;

        public SetActionListener(String setName, boolean goLastSet) {
            this.setName = setName;
            this.goLastSet = goLastSet;
        }

        public void handle(ActionEvent e) {
            if (this.goLastSet && DefaultLetterKeyboard.this.currentSetName.equals(((Layout)DefaultLetterKeyboard.this.layouts.get(this.setName)).getCode()) && DefaultLetterKeyboard.this.lastSetName != null) {
                DefaultLetterKeyboard.this.currentSetName = DefaultLetterKeyboard.this.lastSetName;
                DefaultLetterKeyboard.this.lastSetName = null;
                DefaultLetterKeyboard.this.refreshSet();
            } else if (!DefaultLetterKeyboard.this.currentSetName.equals(((Layout)DefaultLetterKeyboard.this.layouts.get(this.setName)).getCode())) {
                DefaultLetterKeyboard.this.lastSetName = DefaultLetterKeyboard.this.currentSetName;
                DefaultLetterKeyboard.this.currentSetName = ((Layout)DefaultLetterKeyboard.this.layouts.get(this.setName)).getCode();
                DefaultLetterKeyboard.this.refreshSet();
            }
        }
    }

    private class CapsActionListener
    implements EventHandler<ActionEvent> {
        private CapsActionListener() {
        }

        public void handle(ActionEvent e) {
            if (DefaultLetterKeyboard.this.currentCase == KeyboardCase.Lower) {
                DefaultLetterKeyboard.this.currentCase = KeyboardCase.Upper;
            } else {
                DefaultLetterKeyboard.this.currentCase = KeyboardCase.Lower;
            }
            DefaultLetterKeyboard.this.refreshSet();
        }
    }
}

