/*
 * Decompiled with CFR 0.152.
 */
package plfx.element.scale;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Labeled;
import plfx.element.scale.ScaleLabeledListener;
import plfx.element.scale.ScaleProfiles;

public final class ScaleWrapper {
    private static final String PREFIX = "prefix";
    private static final String LENGTH = "lengths";

    public static void wrapLabeled(Labeled labeled, String profileName) {
        Properties scaleProfile = ScaleProfiles.getScaleProfile(profileName);
        if (!scaleProfile.isEmpty()) {
            String prefix = scaleProfile.getProperty(PREFIX);
            String length = scaleProfile.getProperty(LENGTH);
            if (prefix == null || prefix.isEmpty() || length == null) {
                return;
            }
            List<Integer> lengthList = Stream.of(length.split(",")).map(str -> str.trim()).filter(str -> !str.isEmpty()).map(str -> Integer.parseInt(str)).collect(Collectors.toList());
            labeled.textProperty().addListener((ChangeListener)new ScaleLabeledListener(labeled, prefix, lengthList));
        }
    }

    public static void wrapLabeled(Labeled labeled, String profileName, Labeled observableLabeled) {
        Properties scaleProfile = ScaleProfiles.getScaleProfile(profileName);
        if (!scaleProfile.isEmpty()) {
            String prefix = scaleProfile.getProperty(PREFIX);
            String length = scaleProfile.getProperty(LENGTH);
            if (prefix == null || prefix.isEmpty() || length == null) {
                return;
            }
            List<Integer> lengthList = Stream.of(length.split(",")).map(str -> str.trim()).filter(str -> !str.isEmpty()).map(str -> Integer.parseInt(str)).collect(Collectors.toList());
            observableLabeled.textProperty().addListener((ChangeListener)new ScaleLabeledListener(labeled, prefix, lengthList));
        }
    }
}

