/*
 * Decompiled with CFR 0.152.
 */
package plfx.element.scale;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Labeled;

public class ScaleLabeledListener
implements ChangeListener<String> {
    private final Labeled element;
    private final Map<Integer, String> prefixs;
    private final List<Integer> lengths;

    public ScaleLabeledListener(Labeled element, String prefix, List<Integer> lengths) {
        this.element = element;
        this.prefixs = lengths.stream().sorted((o1, o2) -> o2 - o1).collect(Collectors.toMap(Function.identity(), i -> prefix + "-" + i));
        this.lengths = lengths;
        this.lengths.sort((o1, o2) -> o2 - o1);
    }

    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        this.element.getStyleClass().removeIf(cl -> this.prefixs.containsValue(cl));
        for (Integer i : this.lengths) {
            if (newValue.length() < i) continue;
            this.element.getStyleClass().add((Object)this.prefixs.get(i));
            break;
        }
    }
}

