/*
 * Decompiled with CFR 0.152.
 */
package plfx.element;

import javafx.scene.control.Label;
import javafx.scene.web.WebView;
import org.apache.commons.lang.StringUtils;
import plfx.element.SLabel;
import plfx.element.WebViewHelper;
import plfx.screen.ScrollListener;
import plfx.util.TerminalPlatform;

public class WebViewSLabel
implements SLabel {
    private static final String SCROLL_TO_BOTTOM_ALERT = "scroll_to_bottom";
    private final WebView view;
    private String javaScript;
    private ScrollListener scrollListener;

    public WebViewSLabel(WebView view) {
        if (view == null) {
            throw new NullPointerException("WebView");
        }
        this.view = view;
        view.getEngine().setUserStyleSheetLocation(WebViewHelper.getWebViewCssAsData());
        this.javaScript = WebViewHelper.getWebViewJsAsString();
        if (!StringUtils.isEmpty((String)this.javaScript) && this.javaScript.contains(SCROLL_TO_BOTTOM_ALERT)) {
            view.getEngine().setOnAlert(e -> {
                if (SCROLL_TO_BOTTOM_ALERT.equals(e.getData()) && this.scrollListener != null) {
                    TerminalPlatform.runLater(() -> this.scrollListener.scrollToBottom());
                }
            });
        }
    }

    @Override
    public void setScrollListener(ScrollListener scrollListener) {
        this.scrollListener = scrollListener;
    }

    @Override
    public void setText(String text) {
        if (!StringUtils.isEmpty((String)this.javaScript)) {
            text = "<script>\n" + this.javaScript + "\n</script>\n" + text;
        }
        this.view.getEngine().loadContent(text);
    }

    @Override
    public void setVisible(boolean visible) {
        this.view.setVisible(visible);
    }

    @Override
    public Label getText() {
        return null;
    }
}

