/*
 * Decompiled with CFR 0.152.
 */
package plfx.element;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import plfx.element.ButtonListener;
import plfx.element.SButton;
import plfx.element.SafeButtonListener;

public class ComplexSButton
implements SButton,
EventHandler<MouseEvent> {
    private final Pane pane;
    private Pane icon;
    private Label title;
    private Label hint;
    private ButtonListener listener;

    public ComplexSButton(Pane pane) {
        this.pane = pane;
        if (pane != null) {
            pane.setOnMouseClicked((EventHandler)this);
            this.title = (Label)pane.lookup(".button-label");
            this.hint = (Label)pane.lookup(".button-hint");
            this.icon = (Pane)pane.lookup(".button-icon");
        }
    }

    @Override
    public void setText(String text) {
        if (this.title != null) {
            this.title.setText(text);
        }
    }

    @Override
    public void setDisable(boolean disable) {
        if (this.pane != null) {
            this.pane.setDisable(disable);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.pane != null) {
            this.pane.setVisible(visible);
        }
    }

    @Override
    public void setListener(ButtonListener listener) {
        if (this.pane != null) {
            this.listener = new SafeButtonListener(listener);
        }
    }

    public void handle(MouseEvent t) {
        if (this.listener != null) {
            this.listener.onAction();
        }
    }

    @Override
    public void setImage(String path) {
        if (this.icon != null) {
            if (path != null) {
                this.icon.setStyle("-fx-background-image:    url(\"" + path + "\");");
            } else {
                this.icon.setStyle("");
            }
        }
    }

    @Override
    public Node getNode() {
        return this.pane;
    }

    public Label getTitle() {
        return this.title;
    }

    @Override
    public Label getHint() {
        return this.hint;
    }

    @Override
    public void setHint(String text) {
        if (this.hint != null) {
            this.hint.setText(text);
        }
    }
}

