/*
 * Decompiled with CFR 0.152.
 */
package plfx.controller.page;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import plfx.controller.page.BasePageController;

public abstract class NodePageController<T extends Node>
extends BasePageController
implements Initializable {
    @FXML
    protected T forward;
    @FXML
    protected T backward;

    public NodePageController() {
    }

    public NodePageController(T forward, T backward) {
        this.check((Node)forward, (Node)backward);
        this.forward = forward;
        this.backward = backward;
    }

    @Override
    protected void reinit() {
        this.forward.setVisible(this.count > 1);
        this.backward.setVisible(this.count > 1);
        this.backward.setDisable(this.index == 0);
        this.forward.setDisable(this.index == this.count - 1);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.check((Node)this.forward, (Node)this.backward);
        this.forward.setVisible(false);
        this.backward.setVisible(false);
        this.attach();
    }

    protected void processClick(Object object) {
        if (this.forward.equals(object)) {
            if (this.index < this.count - 1) {
                ++this.index;
            }
        } else if (this.index > 0) {
            --this.index;
        }
        this.forward.setDisable(this.index == this.count - 1);
        this.backward.setDisable(this.index == 0);
        this.notifyListeners(this.index);
    }

    private void check(Node forward, Node backward) {
        if (forward == null) {
            throw new IllegalArgumentException("Button with fx:id='forward' is not found");
        }
        if (backward == null) {
            throw new IllegalArgumentException("Button with fx:id='backward' is not found");
        }
    }

    protected abstract void attach();
}

