/*
 * Decompiled with CFR 0.152.
 */
package plfx.controller.page;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import plfx.controller.page.BasePageController;

public class BoxPageController
extends BasePageController
implements Initializable,
EventHandler<ActionEvent> {
    protected static final String STYLE_CLASS_PAGE_BUTTON = "page-button";
    protected static final String STYLE_CLASS_SELECTED_BUTTON = "page-button-selected";
    @FXML
    private Pane pager;
    private final List<Button> buttons = new LinkedList<Button>();
    private Button selected;

    public void initialize(URL url, ResourceBundle rb) {
        if (this.pager == null) {
            throw new IllegalArgumentException("Pane with fx:id='pager' is not found");
        }
        for (int i = 0; i < 10; ++i) {
            Button b = new Button(Integer.toString(i + 1));
            b.setOnAction((EventHandler)this);
            b.setMaxHeight(Double.MAX_VALUE);
            b.getStyleClass().add((Object)STYLE_CLASS_PAGE_BUTTON);
            this.buttons.add(b);
        }
    }

    @Override
    public void reinit() {
        this.pager.getChildren().clear();
        if (this.count > 1) {
            for (int i = 0; i < this.count && i < this.buttons.size(); ++i) {
                this.pager.getChildren().add((Object)this.buttons.get(i));
            }
        }
        this.processButton(this.buttons.get(this.index), false);
    }

    public void handle(ActionEvent event) {
        this.processButton((Button)event.getSource(), true);
    }

    public void processButton(Button button, boolean notify) {
        if (!button.equals(this.selected)) {
            if (this.selected != null) {
                this.selected.getStyleClass().remove((Object)STYLE_CLASS_SELECTED_BUTTON);
            }
            button.getStyleClass().add((Object)STYLE_CLASS_SELECTED_BUTTON);
            this.selected = button;
            if (notify) {
                this.notifyListeners(this.buttons.indexOf(button));
            }
        }
    }
}

