/*
 * Decompiled with CFR 0.152.
 */
package plfx.controller.page;

import plfx.controller.page.PageController;
import plfx.controller.page.PageListener;

abstract class BasePageController
implements PageController {
    private PageListener listener;
    protected int count = 1;
    protected int index = 0;

    BasePageController() {
    }

    @Override
    public void init(int count, int pageNo) {
        if (count < 1) {
            throw new IllegalArgumentException("Count must be positive");
        }
        if (pageNo < 0 || pageNo >= count) {
            throw new IllegalArgumentException("PageNo must be in range 0.." + (count - 1));
        }
        this.count = count;
        this.index = pageNo;
        this.reinit();
    }

    protected abstract void reinit();

    @Override
    public void setListener(PageListener listener) {
        if (listener == null) {
            throw new NullPointerException("PageListener is null");
        }
        this.listener = listener;
    }

    protected void notifyListeners(int index) {
        if (this.listener != null) {
            this.listener.onPage(index);
        }
    }
}

