/*
 * Decompiled with CFR 0.152.
 */
package plfx.controller.lang;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import plfx.controller.lang.BaseLangController;
import plfx.controller.lang.Lang;

public class ComboBoxLangController
extends BaseLangController
implements Initializable,
EventHandler<ActionEvent> {
    @FXML
    private ComboBox<Lang> langBox;
    private Lang first;
    private Lang last;

    public void initialize(URL location, ResourceBundle resources) {
        if (this.langBox == null) {
            throw new IllegalArgumentException("ComboBox with fx:id='langBox' is not found");
        }
        this.langBox.setOnAction((EventHandler)this);
        this.langBox.setCellFactory(param -> new ListCell<Lang>(){

            protected void updateItem(Lang item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.toString());
                    this.getStyleClass().remove((Object)"list-cell-first");
                    this.getStyleClass().remove((Object)"list-cell-last");
                    if (item.equals(ComboBoxLangController.this.first)) {
                        this.getStyleClass().add((Object)"list-cell-first");
                    } else if (item.equals(ComboBoxLangController.this.last)) {
                        this.getStyleClass().add((Object)"list-cell-last");
                    }
                }
            }
        });
    }

    @Override
    protected void _init() {
        this.first = (Lang)this.langs.get(0);
        this.last = (Lang)this.langs.get(this.langs.size() - 1);
        this.langBox.setItems(this.langs);
        this.langBox.getSelectionModel().select((Object)this.selected);
    }

    public void handle(ActionEvent event) {
        this.selected = (Lang)this.langBox.getSelectionModel().getSelectedItem();
        this.notifyListeners(this.selected);
    }
}

