/*
 * Decompiled with CFR 0.152.
 */
package plfx.controller.lang;

import javafx.collections.ObservableList;
import plfx.controller.lang.Lang;
import plfx.controller.lang.LangController;
import plfx.screen.menu.MenuTemplateListener;

abstract class BaseLangController
implements LangController {
    private MenuTemplateListener listener;
    protected Lang selected;
    protected ObservableList<Lang> langs;

    BaseLangController() {
    }

    @Override
    public void init(Lang currLang, ObservableList<Lang> langs) {
        if (currLang == null || currLang.getCode() == null || !currLang.getCode().matches("[a-z]{2}")) {
            throw new IllegalArgumentException("Current language is not set");
        }
        if (langs == null || langs.isEmpty()) {
            throw new IllegalArgumentException("Available languages count must be greater than 0");
        }
        this.selected = currLang;
        this.langs = langs;
        this._init();
    }

    protected abstract void _init();

    @Override
    public void setListener(MenuTemplateListener listener) {
        if (listener == null) {
            throw new NullPointerException("LangListener is null");
        }
        this.listener = listener;
    }

    protected void notifyListeners(Lang lang) {
        if (this.listener != null && lang != null) {
            this.listener.onSelectLang(lang.getCode());
        }
    }
}

