/*
 * Decompiled with CFR 0.152.
 */
package plfx.controller;

import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import plfx.controller.BaseInfoAreaController;
import ru.softlogic.input.model.InputElement;

public class VBoxInfoAreaController
extends BaseInfoAreaController
implements Initializable {
    private static final String STYLE_CLASS_BIG_ITEM = "big-item";
    private static final String STYLE_CLASS_MEDIUM_ITEM = "medium-item";
    private static final String STYLE_CLASS_LITTLE_ITEM = "little-item";
    private static final String STYLE_CLASS_TITLE = "title-label";
    private static final String STYLE_CLASS_VALUE = "value-label";
    @FXML
    private VBox base;

    @Override
    public void show(List<InputElement> elements) {
        if (elements.size() < 3) {
            this.fill(new VBoxSupplier(), elements, STYLE_CLASS_BIG_ITEM);
        } else if (elements.size() < 5) {
            this.fill(new VBoxSupplier(), elements, STYLE_CLASS_MEDIUM_ITEM);
        } else {
            this.fill(new HBoxSupplier(), elements, STYLE_CLASS_LITTLE_ITEM);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        if (this.base == null) {
            throw new IllegalArgumentException("VBox with fx:id='base' is not found");
        }
    }

    private void fill(Supplier<? extends Pane> supplier, List<InputElement> elements, String styleClass) {
        this.base.getChildren().clear();
        for (InputElement ie : elements) {
            Label title = this.createLabel(ie.getKeyTitle(), 1800, STYLE_CLASS_TITLE);
            Label value = this.createLabel(ie.getValueTitle(), 2000, STYLE_CLASS_VALUE);
            Pane container = supplier.get();
            container.getStyleClass().add((Object)styleClass);
            container.getChildren().add((Object)title);
            container.getChildren().add((Object)value);
            this.base.getChildren().add((Object)container);
        }
    }

    private Label createLabel(String title, int prefWidth, String styleClass) {
        Label l = new Label(title);
        l.setPrefWidth((double)prefWidth);
        l.getStyleClass().add((Object)STYLE_CLASS_TITLE);
        return l;
    }

    private class HBoxSupplier
    implements Supplier<HBox> {
        private HBoxSupplier() {
        }

        @Override
        public HBox get() {
            HBox b = new HBox();
            b.setAlignment(Pos.CENTER);
            return b;
        }
    }

    private class VBoxSupplier
    implements Supplier<VBox> {
        private VBoxSupplier() {
        }

        @Override
        public VBox get() {
            VBox b = new VBox();
            b.setAlignment(Pos.CENTER);
            return b;
        }
    }
}

