/*
 * Decompiled with CFR 0.152.
 */
package plfx.adv;

import java.util.concurrent.atomic.AtomicInteger;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import plfx.adv.AdClickLisnener;
import plfx.adv.AdContentType;
import plfx.adv.AdPlace;

public class SimpleAdPlace
implements AdPlace,
EventHandler<MouseEvent> {
    private Pane pane;
    private String id;
    private AdClickLisnener lisnener;
    private AtomicInteger timeLeft;

    public SimpleAdPlace(Pane pane, String id) {
        if (pane == null) {
            throw new NullPointerException("Pane is null");
        }
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("Place ID is not set");
        }
        this.pane = pane;
        this.id = id;
        this.timeLeft = new AtomicInteger();
        pane.setOnMousePressed((EventHandler)this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void showContent(String path, AdContentType type, AdClickLisnener lisnener) {
        this.lisnener = lisnener;
        if (path != null && type == AdContentType.Image) {
            this.pane.setStyle("-fx-background-image: url('" + path + "');    -fx-background-repeat: stretch;    -fx-background-size: stretch;    -fx-background-position: center;");
            if (!this.pane.isVisible()) {
                this.pane.setVisible(true);
            }
        } else {
            this.pane.setStyle("");
            this.pane.setVisible(false);
        }
    }

    public void handle(MouseEvent t) {
        if (this.lisnener != null) {
            this.lisnener.onClick();
        }
    }

    public String toString() {
        return "SimpleAdPlace{id=" + this.id + ", pane=" + this.pane + '}';
    }

    @Override
    public AtomicInteger getTimeLeft() {
        return this.timeLeft;
    }
}

