/*
 * Decompiled with CFR 0.152.
 */
package plfx.adv;

import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import plfx.adv.AdClickLisnener;
import plfx.adv.AdContentType;
import plfx.adv.AdPlace;

public class AdvancedAdPlace
implements AdPlace,
EventHandler<MouseEvent> {
    private StackPane stackPane;
    private String id;
    private AdClickLisnener lisnener;
    private AtomicInteger timeLeft;
    private String lastPath;
    private Pane bg;
    private Pane[] imgScreen;
    private int idxImgScreen;
    private boolean showEffect;
    private WebView htmlScreen;
    private boolean clickDisable;

    public AdvancedAdPlace(StackPane stackPane, String id) {
        if (stackPane == null) {
            throw new NullPointerException("StackPane is not set");
        }
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("Place ID is not set");
        }
        this.stackPane = stackPane;
        this.id = id;
        this.timeLeft = new AtomicInteger();
        this.clickDisable = "true".equals(stackPane.getProperties().get((Object)"clickDisable"));
        this.showEffect = "true".equals(stackPane.getProperties().get((Object)"showEffect"));
        this.bg = new Pane();
        this.bg.getStyleClass().add((Object)("adplace-" + id.toLowerCase() + "-pane-bg"));
        this.bg.setVisible(true);
        stackPane.getChildren().add((Object)this.bg);
        this.imgScreen = new Pane[2];
        this.imgScreen[0] = new Pane();
        this.imgScreen[0].getStyleClass().add((Object)("adplace-" + id.toLowerCase() + "-pane"));
        this.imgScreen[0].setMouseTransparent(true);
        this.imgScreen[0].setOnMousePressed((EventHandler)this);
        this.imgScreen[0].setVisible(false);
        stackPane.getChildren().add((Object)this.imgScreen[0]);
        this.imgScreen[1] = new Pane();
        this.imgScreen[1].getStyleClass().add((Object)("adplace-" + id.toLowerCase() + "-pane"));
        this.imgScreen[1].setOnMousePressed((EventHandler)this);
        this.imgScreen[1].setVisible(false);
        stackPane.getChildren().add((Object)this.imgScreen[1]);
        this.htmlScreen = new WebView();
        this.htmlScreen.setOnMouseClicked((EventHandler)this);
        this.htmlScreen.setVisible(false);
        stackPane.getChildren().add((Object)this.htmlScreen);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void showContent(String path, AdContentType type, AdClickLisnener lisnener) {
        this.lisnener = lisnener;
        if (path == null) {
            this.imgScreen[0].setStyle("");
            this.imgScreen[0].setVisible(false);
            this.imgScreen[1].setStyle("");
            this.imgScreen[1].setVisible(false);
            this.htmlScreen.setVisible(false);
            this.lastPath = null;
            this.idxImgScreen = 0;
            this.bg.setVisible(true);
        } else if (type == AdContentType.Html) {
            if (path.equals(this.lastPath)) {
                return;
            }
            this.bg.setVisible(false);
            this.imgScreen[0].setStyle("");
            this.imgScreen[0].setVisible(false);
            this.imgScreen[1].setStyle("");
            this.imgScreen[1].setVisible(false);
            this.idxImgScreen = 0;
            this.htmlScreen.setVisible(true);
            this.htmlScreen.getEngine().load(path);
            this.lastPath = path;
        } else if (type == AdContentType.Image) {
            if (path.equals(this.lastPath)) {
                return;
            }
            this.bg.setVisible(false);
            this.htmlScreen.setVisible(false);
            this.imgScreen[0].setVisible(true);
            this.imgScreen[1].setVisible(true);
            this.imgScreen[this.idxImgScreen].setStyle("-fx-background-image: url('" + path + "');-fx-background-repeat: no-repeat;-fx-background-size: stretch;-fx-background-position: center;");
            int idxImgScreen2 = (this.idxImgScreen + 1) % 2;
            this.stackPane.setOnMousePressed((EventHandler)this);
            if (this.showEffect) {
                FadeTransition ft1 = new FadeTransition(Duration.seconds((double)2.0), (Node)this.imgScreen[idxImgScreen2]);
                ft1.setFromValue(1.0);
                ft1.setToValue(0.0);
                FadeTransition ft2 = new FadeTransition(Duration.seconds((double)2.0), (Node)this.imgScreen[this.idxImgScreen]);
                ft2.setFromValue(0.0);
                ft2.setToValue(1.0);
                ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{ft1, ft2});
                parallelTransition.setCycleCount(1);
                parallelTransition.play();
            } else {
                this.imgScreen[this.idxImgScreen].setOpacity(1.0);
                this.imgScreen[idxImgScreen2].setOpacity(0.0);
            }
            this.idxImgScreen = idxImgScreen2;
            this.lastPath = path;
        }
    }

    public void handle(MouseEvent t) {
        if (this.lisnener != null && !this.clickDisable) {
            this.lisnener.onClick();
        }
    }

    public String toString() {
        return "StackAdPlace{id=" + this.id + ", pane=" + this.stackPane + '}';
    }

    @Override
    public AtomicInteger getTimeLeft() {
        return this.timeLeft;
    }
}

