/*
 * Decompiled with CFR 0.152.
 */
package plfx;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import plfx.SystemTimeMarker;
import plfx.TimeMarker;

public abstract class GuiNotifier {
    private static final Logger LOG = Logger.getLogger(GuiNotifier.class);
    public static final int TIMEOUT_5MIN = 300;
    public static final int TIMEOUT_10MIN = 600;
    public static final int TIMEOUT_15MIN = 900;
    private static GuiNotifier instance;
    private static TimeMarker timeMarker;
    private static final Set<Integer> messages;
    private static final Map<Integer, Long> timeouts;

    public static void init(GuiNotifier instance, TimeMarker timeMarker) {
        if (instance == null) {
            throw new NullPointerException("Instance is null");
        }
        if (timeMarker == null) {
            throw new NullPointerException("TimeMarker is null");
        }
        GuiNotifier.instance = instance;
        GuiNotifier.timeMarker = timeMarker;
    }

    protected abstract void onError(Throwable var1);

    protected abstract void onError(String var1);

    protected abstract void onProblem(String var1);

    protected abstract void onRequestRestart(String var1);

    public static void notifyError(Throwable ex) {
        if (instance != null) {
            instance.onError(ex);
        }
    }

    public static void notifyError(String message) {
        if (instance != null) {
            instance.onError(message);
        }
    }

    public static void notifyProblem(String message) {
        if (instance != null) {
            instance.onProblem(message);
        }
    }

    public static void requestRestart(String cause) {
        if (instance != null) {
            instance.onRequestRestart(cause);
        }
    }

    public static void notifyErrorOnce(String message) {
        if (message == null) {
            return;
        }
        int mHash = message.hashCode();
        if (messages.contains(mHash)) {
            return;
        }
        messages.add(mHash);
        GuiNotifier.notifyError(message);
    }

    public static void notifyProblemOnce(String message) {
        if (message == null) {
            return;
        }
        int mHash = message.hashCode();
        if (messages.contains(mHash)) {
            return;
        }
        messages.add(mHash);
        GuiNotifier.notifyProblem(message);
    }

    public static void notifyError(String message, int timeout) {
        if (GuiNotifier.canNotify(message, timeout)) {
            GuiNotifier.notifyError(message);
        }
    }

    public static void notifyProblemOnce(String message, int timeout) {
        if (GuiNotifier.canNotify(message, timeout)) {
            long t1 = System.currentTimeMillis();
            GuiNotifier.notifyProblem(message);
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 10L) {
                LOG.error((Object)("GuiNotifier:notifyProblemOnce " + (t2 - t1)));
            }
        }
    }

    private static boolean canNotify(String message, int timeout) {
        if (message == null) {
            return false;
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("Timeout must be positive");
        }
        long current = timeMarker.getMark();
        int mHash = message.hashCode();
        Long mark = timeouts.get(mHash);
        if (mark != null && current - mark < (long)timeout) {
            return false;
        }
        timeouts.put(mHash, current);
        return true;
    }

    static {
        timeMarker = new SystemTimeMarker();
        messages = new HashSet<Integer>();
        timeouts = new HashMap<Integer, Long>();
    }
}

