/*
 * Decompiled with CFR 0.152.
 */
package plfx;

import java.io.File;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.scene.media.AudioClip;
import org.apache.log4j.Logger;

public class AudioPlayerFx {
    public static final String SOUND_DIRECTORY_PATH = "res" + File.separator + "sound";
    public static final String STD_SOUND_OPERATOR = "operator.mp3";
    public static final String STD_SOUND_CLICK = "_click.mp3";
    public static final String STD_SOUND_COMPLETE = "complete.mp3";
    public static final String STD_SOUND_HELLO = "hello.mp3";
    public static final String STD_SOUND_PAY_DATA = "pay_data.mp3";
    private static final AudioPlayerFx instance = new AudioPlayerFx();
    private final Logger log = Logger.getLogger((String)"sound");
    private AudioClip player;
    private final BlockingQueue<String> queue;
    private String directory;
    private Locale locale;
    private final Thread playerThread;

    private AudioPlayerFx() {
        this.log.setAdditivity(false);
        this.queue = new LinkedBlockingQueue<String>();
        this.playerThread = new Thread((Runnable)new PlayerThread(), "MediaPlayerFx");
        this.playerThread.setDaemon(true);
    }

    public static AudioPlayerFx getInstance() {
        return instance;
    }

    public void setDirectory(String directory) {
        this.directory = directory != null ? directory : "";
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void start() {
        this.playerThread.start();
    }

    public synchronized void play(String soundFile) {
        this.log.debug((Object)("Add: " + soundFile));
        this.queue.add(soundFile);
    }

    private class PlayerThread
    implements Runnable {
        private String lastFile;

        private PlayerThread() {
        }

        @Override
        public void run() {
            AudioPlayerFx.this.log.debug((Object)"Start thread");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    String file = (String)AudioPlayerFx.this.queue.take();
                    AudioClip lp = AudioPlayerFx.this.player;
                    if (lp != null) {
                        if (this.lastFile != null && this.lastFile.startsWith("_")) {
                            AudioPlayerFx.this.log.debug((Object)"\u0416\u0434\u0443 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0440\u0435\u043a\u0430");
                            while (lp.isPlaying()) {
                                Thread.sleep(50L);
                            }
                        } else {
                            AudioPlayerFx.this.log.debug((Object)"\u041e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u044e \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0442\u0440\u0435\u043a\u0430");
                            lp.stop();
                        }
                    }
                    if (AudioPlayerFx.this.locale != null && new File(AudioPlayerFx.this.directory + AudioPlayerFx.this.locale.getLanguage() + File.separator + file).exists()) {
                        AudioPlayerFx.this.player = new AudioClip(Paths.get(AudioPlayerFx.this.directory + AudioPlayerFx.this.locale.getLanguage() + File.separator + file, new String[0]).toUri().toString());
                    } else if (new File(AudioPlayerFx.this.directory + file).exists()) {
                        AudioPlayerFx.this.player = new AudioClip(Paths.get(AudioPlayerFx.this.directory + file, new String[0]).toUri().toString());
                    } else {
                        AudioPlayerFx.this.log.debug((Object)("\u0424\u0430\u0439\u043b " + file + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"));
                        AudioPlayerFx.this.player = null;
                    }
                    if (AudioPlayerFx.this.player == null) continue;
                    AudioPlayerFx.this.log.debug((Object)("\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0435: " + file));
                    AudioPlayerFx.this.player.play();
                    this.lastFile = file;
                }
                catch (InterruptedException ex) {
                    AudioPlayerFx.this.log.debug((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u043f\u043e\u0442\u043e\u043a");
                    Thread.currentThread().interrupt();
                }
                catch (Throwable ex) {
                    AudioPlayerFx.this.log.debug((Object)"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043b\u0435\u0439\u0435\u0440\u0430", ex);
                }
            }
            AudioPlayerFx.this.log.debug((Object)"Stop thread");
        }
    }
}

