/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.utility.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.scene.input.MouseEvent;
import plfx.element.ButtonListener;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.KeyboardModelListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.model.textfield.TextFieldModel;
import plfx.screen.FxScreenTemplate;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.screen.utility.search.SearchListener;
import plfx.screen.utility.search.SearchScreen;
import plfx.screen.utility.search.SearchTemplate;
import plfx.showcase.screen.utility.search.ShowcaseSearchTemplate;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.VoidFilter;

public class ShowcaseSearchScreen
implements SearchScreen {
    private SearchTemplate template;
    private SearchListener listener;
    private LetterKeyboard keyboard;
    private TextFieldModel model;
    private List<String> kbds;
    private Locale currentLocale;

    public ShowcaseSearchScreen(SearchTemplate template, Map<String, Layout> layouts) {
        if (template == null) {
            throw new NullPointerException();
        }
        this.template = template;
        template.getBackButton().setListener((ButtonListener)new ExitListener());
        template.getPrevButton().setListener((ButtonListener)new PrevListener());
        template.getNextButton().setListener((ButtonListener)new NextListener());
        this.keyboard = template.getLetterKeyboard();
        this.keyboard.setLayouts(layouts);
        this.kbds = new LinkedList<String>();
        for (Layout l : layouts.values()) {
            if ("symb".equals(l.getCode())) continue;
            this.kbds.add(l.getCode());
        }
        this.model = new TextFieldModel(20, "", "", false, (Filter)new VoidFilter());
        this.model.addListener((FieldListener)new LocalFieldListener());
        this.keyboard.setKeyboardListener((KeyboardListener)new KeyboardModelListener((InputFieldModel)this.model));
        if (template instanceof ShowcaseSearchTemplate) {
            ShowcaseSearchTemplate sst = (ShowcaseSearchTemplate)template;
            sst.getNotfoundPane().addEventHandler(MouseEvent.MOUSE_CLICKED, event -> this.listener.onAddService());
        }
    }

    public void init() {
        this.model.clear();
        this.kbds.sort((l1, l2) -> {
            if (l1.equalsIgnoreCase(this.currentLocale.getLanguage())) {
                return -1;
            }
            if (l2.equalsIgnoreCase(this.currentLocale.getLanguage())) {
                return 1;
            }
            return 0;
        });
        this.keyboard.init(new Keyboard(KeyboardType.Any, this.kbds, KeyboardCase.Upper, true, null));
    }

    public void setListener(SearchListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is not set");
        }
        this.listener = listener;
    }

    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    public int getButtonCount() {
        return this.template.getButtonArea().getCapacity();
    }

    public void update(List<MenuButtonInit> inits, boolean showPrev, boolean showNext) {
        this.template.update(inits, showPrev, showNext);
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }

    private class NextListener
    implements ButtonListener {
        private NextListener() {
        }

        public void onAction() {
            if (ShowcaseSearchScreen.this.listener != null) {
                ShowcaseSearchScreen.this.listener.onBrowseNext();
            }
        }
    }

    private class PrevListener
    implements ButtonListener {
        private PrevListener() {
        }

        public void onAction() {
            if (ShowcaseSearchScreen.this.listener != null) {
                ShowcaseSearchScreen.this.listener.onBrowsePrev();
            }
        }
    }

    private class ExitListener
    implements ButtonListener {
        private ExitListener() {
        }

        public void onAction() {
            if (ShowcaseSearchScreen.this.listener != null) {
                ShowcaseSearchScreen.this.listener.onExit();
            }
        }
    }

    private class LocalFieldListener
    implements FieldListener {
        private LocalFieldListener() {
        }

        public void onChange(String value) {
            ShowcaseSearchScreen.this.template.getRequestLabel().setText(value);
            if (ShowcaseSearchScreen.this.listener != null) {
                ShowcaseSearchScreen.this.listener.onRequest(value);
            }
        }

        public void onEnter(String value) {
            if (ShowcaseSearchScreen.this.listener != null) {
                ShowcaseSearchScreen.this.listener.onRequest(value);
            }
        }
    }
}

