/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.offer;

import javafx.scene.web.WebView;
import plfx.element.ButtonListener;
import plfx.screen.offer.DefaultOfferScreen;
import plfx.screen.offer.OfferTemplate;
import plfx.showcase.screen.offer.ShowcaseOfferTemplate;

public class ShowcaseOfferScreen
extends DefaultOfferScreen {
    private static final int SCROLL_VALUE = 100;

    public ShowcaseOfferScreen(OfferTemplate template) {
        super(template);
        if (template instanceof ShowcaseOfferTemplate) {
            ShowcaseOfferTemplate sot = (ShowcaseOfferTemplate)template;
            sot.getDecBtn().setOnAction(e -> this.scrollTo(template.getWebView(), 0, this.getVScrollValue(template.getWebView()) - 100));
            sot.getIncBtn().setOnAction(e -> this.scrollTo(template.getWebView(), 0, this.getVScrollValue(template.getWebView()) + 100));
            sot.getBackBtn().setListener((ButtonListener)new BackListener());
            sot.getSearchBtn().setListener((ButtonListener)new ServiceSearchListener());
            sot.getExitBtn().setListener((ButtonListener)new CloseListener());
        }
    }

    private void scrollTo(WebView view, int x, int y) {
        if (view != null) {
            view.getEngine().executeScript("window.scrollTo(" + x + ", " + y + ")");
        }
    }

    private int getVScrollValue(WebView view) {
        if (view != null) {
            return (Integer)view.getEngine().executeScript("document.body.scrollTop");
        }
        return 0;
    }

    private class BackListener
    implements ButtonListener {
        private BackListener() {
        }

        public void onAction() {
            if (ShowcaseOfferScreen.this.listener != null) {
                ShowcaseOfferScreen.this.listener.onHelp();
            }
        }
    }

    private class ServiceSearchListener
    implements ButtonListener {
        private ServiceSearchListener() {
        }

        public void onAction() {
            if (ShowcaseOfferScreen.this.listener != null) {
                ShowcaseOfferScreen.this.listener.onSearchService();
            }
        }
    }

    private class CloseListener
    implements ButtonListener {
        private CloseListener() {
        }

        public void onAction() {
            if (ShowcaseOfferScreen.this.listener != null) {
                ShowcaseOfferScreen.this.listener.onBack();
            }
        }
    }
}

