/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.menu.service;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import plfx.GuiNotifier;
import plfx.element.ButtonListener;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.msg.MessageTemplate;
import plfx.msg.SimpleMessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.menu.BaseMenuTemplate;
import plfx.screen.menu.StyleExtractor;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.area.InfiniteButtonArea;
import plfx.screen.menu.area.VoidButtonArea;
import plfx.screen.menu.button.MenuButton;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.util.Locator;
import ru.softlogic.input.model.screen.ActionType;

public class ShowcaseServiceMenuTemplate
extends BaseMenuTemplate {
    private static final int MAX_COLUMN = 7;
    private static final int MAX_ROW = 4;
    private static final int MIX_AREA_BTNS = 28;
    private static final int MIX_AREA_MAX_BTNS = 90;
    private static final String DEFAULT_STYLE = "default-mixed";
    private static final String TEXT_TPL_PREV = "mixed_prev";
    private static final String TEXT_TPL_NEXT = "mixed_next";
    private final List<MenuButton> mixedButtons;
    private final ButtonArea hotArea;
    private final ButtonArea groupArea;
    private final ButtonArea serviceArea;
    private final ButtonArea mixedArea;
    private final ButtonArea prevgroupArea;
    private final Set<String> styles = new HashSet<String>();
    private SButton mixedPrev;
    private SButton mixedNext;
    @FXML
    private GridPane realMixedGrid;
    @FXML
    private GridPane containerMixedGrid;
    private int currMixShift;
    private int currMixBtnCount;
    private int currentPage;
    private int pageCount;
    private String tplTextPrev;
    private String tplTextNext;

    public ShowcaseServiceMenuTemplate(String screenId) {
        super(screenId);
        this.styles.add("light");
        this.styles.add("dark");
        this.styles.add("black");
        this.styles.add("white");
        this.styles.add("default-prevgroup-pressed");
        this.mixedButtons = new LinkedList<MenuButton>();
        this.hotArea = new VoidButtonArea();
        this.groupArea = new InfiniteButtonArea(null);
        this.prevgroupArea = new InfiniteButtonArea(null);
        this.serviceArea = new InfiniteButtonArea(null);
        this.mixedArea = new InfiniteButtonArea(inits -> {
            this.currMixShift = 0;
            this.currMixBtnCount = 0;
            this.currentPage = 1;
            this.mixedPrev.setVisible(false);
            this.mixedNext.setVisible(inits != null && inits.size() > 28);
            this.pageCount = this.calcPageCount(inits == null ? 0 : inits.size());
            this.initMenuButtons(this.mixedButtons, inits);
        });
    }

    public void init() throws FxInitException {
        super.init();
        this.fill(this.mixedButtons, "mixed");
        this.mixedPrev = this.searchButton("mixedPrev", true);
        this.mixedNext = this.searchButton("mixedNext", true);
        this.mixedPrev.setListener((ButtonListener)new LocalNaviListener("prev"));
        this.mixedNext.setListener((ButtonListener)new LocalNaviListener("next"));
        SimpleMessageTemplate smt = new SimpleMessageTemplate(TEXT_TPL_PREV);
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        this.tplTextPrev = smt.getValue();
        smt = new SimpleMessageTemplate(TEXT_TPL_NEXT);
        ScreenProcessor.process((String)"skin", (MessageTemplate)smt);
        this.tplTextNext = smt.getValue();
    }

    private void fill(List<MenuButton> list, String prefix) throws FxInitException {
        MenuButton mb;
        for (int i = 0; i < 90 && (mb = this.searchMenuButton(prefix + i, prefix)) != null; ++i) {
            list.add(mb);
        }
    }

    private void initMenuButtons(List<MenuButton> buttons, List<MenuButtonInit> inits) {
        this.setVisibleAllMixedButtons(false);
        if (inits != null) {
            for (int i = 0; i < buttons.size() && i < inits.size(); ++i) {
                MenuButtonInit mbi = inits.get(i);
                MenuButton mb = buttons.get(i);
                mb.setListener(mbi.getListener());
                mb.setLocked(mbi.isDisable());
                mb.resetStyles();
                if (this.styles.contains(mbi.getStyleClass())) {
                    mb.addStyleClass(mbi.getStyleClass());
                } else {
                    if (mbi.getStyleClass() != null && !mbi.getStyleClass().isEmpty()) {
                        GuiNotifier.notifyProblemOnce((String)("Button style " + mbi.getStyleClass() + " is not found"));
                    }
                    mb.addStyleClass(DEFAULT_STYLE);
                }
                String fullPath = mbi.getLogo() == null || mbi.getLogo().isEmpty() ? null : Locator.getPath((String)("/gui/skin/{name}/img/" + mbi.getLogo()));
                mb.setLogo(fullPath);
                mb.setTag(this.processTagImagePath(mbi, mb.getTagSize()));
                mb.setComm(mbi.getComm());
            }
            this.returnButtons();
            int minSize = Math.min(28, inits.size());
            this.placeButtons(minSize, 0, false, inits.size() > 28);
        }
    }

    private String processImagePath(String path) {
        return path == null || path.isEmpty() ? null : Locator.getPath((String)("/gui/skin/{name}/img/" + path));
    }

    private String processTagImagePath(MenuButtonInit mbi, String size) {
        Map tags = mbi.getTag();
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        String res = this.processImagePath((String)tags.get(size));
        if (res == null) {
            res = this.processImagePath((String)tags.get("default"));
        }
        return res;
    }

    private void setVisibleAllMixedButtons(boolean visible) {
        for (MenuButton mb : this.mixedButtons) {
            mb.setVisible(visible);
        }
    }

    private int calcPageCount(int size) {
        if (size <= 0) {
            return 0;
        }
        int buttons = size;
        if (buttons > 90) {
            buttons = 90;
        }
        boolean first = true;
        int res = 0;
        while (buttons > 0) {
            int sub;
            if (first && buttons > 28 || !first && buttons > 27) {
                if (first) {
                    sub = 27;
                    first = false;
                } else {
                    sub = 26;
                }
            } else {
                sub = 28;
            }
            buttons -= sub;
            ++res;
        }
        return res;
    }

    private void placeButtons(int bSize, int startIndex, boolean visiblePrev, boolean visibleNext) {
        this.mixedPrev.setText(MessageFormat.format(this.tplTextPrev, this.currentPage - 1, this.pageCount));
        this.mixedNext.setText(MessageFormat.format(this.tplTextNext, this.currentPage + 1, this.pageCount));
        this.currMixBtnCount = 28;
        if (visiblePrev) {
            --this.currMixBtnCount;
        }
        if (visibleNext) {
            --this.currMixBtnCount;
        }
        if (bSize < this.currMixBtnCount) {
            this.currMixBtnCount = bSize;
        }
        int addBtn = 0;
        int btnIdx = 0;
        int shift = 0;
        int idxCorrection = 0;
        boolean end = false;
        for (int i = 0; i < 4; ++i) {
            if (shift == 1) {
                idxCorrection = -1;
            }
            shift = 0;
            int j = 0;
            while (j + shift < 7) {
                if (visiblePrev && i == 0) {
                    shift = 1;
                }
                btnIdx = startIndex + i * 7 + j + idxCorrection;
                this.placeButton(i, j + shift, btnIdx);
                this.mixedButtons.get(btnIdx).setVisible(true);
                if (++addBtn >= this.currMixBtnCount) {
                    end = true;
                    break;
                }
                ++j;
            }
            if (end) break;
        }
        this.realMixedGrid.getChildren().remove((Object)this.mixedNext.getNode());
        this.realMixedGrid.add(this.mixedNext.getNode(), 7, 4);
    }

    private void placeButton(int rowIdx, int columnIdx, int bNumber) {
        Node n = this.containerMixedGrid.lookup("#mixed" + bNumber);
        if (n != null) {
            this.containerMixedGrid.getChildren().remove((Object)n);
            this.realMixedGrid.add(n, columnIdx + 1, rowIdx + 1);
        }
    }

    private void returnButtons() {
        for (int i = 0; i < 90; ++i) {
            Node mb = this.realMixedGrid.lookup("#mixed" + i);
            if (mb == null) continue;
            this.realMixedGrid.getChildren().remove((Object)mb);
            this.containerMixedGrid.add(mb, 0, 0);
        }
    }

    public ButtonArea getHotArea() {
        return this.hotArea;
    }

    public ButtonArea getServiceArea() {
        return this.serviceArea;
    }

    public ButtonArea getGroupArea() {
        return this.groupArea;
    }

    public ButtonArea getMixedArea() {
        return this.mixedArea;
    }

    public ButtonArea getPrevGroupArea() {
        return this.prevgroupArea;
    }

    public void addUserStylesheet(String url) {
        this.styles.addAll(StyleExtractor.extractStyles((String)url));
        this.getPane().getStylesheets().add((Object)url);
    }

    public String toString() {
        return "ShowcaseServiceMenuTemplate{}";
    }

    private class LocalNaviListener
    implements ButtonListener {
        private final String actionType;

        public LocalNaviListener(String actionType) {
            this.actionType = actionType;
        }

        public void onAction() {
            if (ShowcaseServiceMenuTemplate.this.mixedArea.getInits() != null) {
                if (ActionType.isNext((String)this.actionType)) {
                    ShowcaseServiceMenuTemplate.this.currMixShift = ShowcaseServiceMenuTemplate.this.currMixShift + ShowcaseServiceMenuTemplate.this.currMixBtnCount;
                    ShowcaseServiceMenuTemplate.this.currentPage++;
                } else {
                    ShowcaseServiceMenuTemplate.this.currMixShift = ShowcaseServiceMenuTemplate.this.currMixShift - (ShowcaseServiceMenuTemplate.this.currMixShift > 27 ? 26 : 27);
                    ShowcaseServiceMenuTemplate.this.currentPage--;
                }
                boolean visiblePrev = ShowcaseServiceMenuTemplate.this.currMixShift > 0;
                boolean visibleNext = ShowcaseServiceMenuTemplate.this.currMixShift + 28 - 1 < ShowcaseServiceMenuTemplate.this.mixedArea.getInits().size();
                int bSize = ShowcaseServiceMenuTemplate.this.mixedArea.getInits().size() - ShowcaseServiceMenuTemplate.this.currMixShift;
                bSize = bSize > 28 ? 28 : bSize;
                ShowcaseServiceMenuTemplate.this.mixedPrev.setVisible(visiblePrev);
                ShowcaseServiceMenuTemplate.this.mixedNext.setVisible(visibleNext);
                ShowcaseServiceMenuTemplate.this.setVisibleAllMixedButtons(false);
                ShowcaseServiceMenuTemplate.this.returnButtons();
                ShowcaseServiceMenuTemplate.this.placeButtons(bSize, ShowcaseServiceMenuTemplate.this.currMixShift, visiblePrev, visibleNext);
            }
        }
    }
}

