/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.menu.group;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import plfx.GuiNotifier;
import plfx.element.ButtonListener;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.screen.menu.BaseMenuTemplate;
import plfx.screen.menu.StyleExtractor;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.area.InfiniteButtonArea;
import plfx.screen.menu.area.VoidButtonArea;
import plfx.screen.menu.button.MenuButton;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.util.Locator;
import ru.softlogic.input.model.screen.ActionType;

public class ShowcaseGroupMenuTemplate
extends BaseMenuTemplate {
    private static final int MAX_COLUMN = 4;
    private static final int MAX_ROW = 3;
    private static final int GRP_AREA_BTNS = 12;
    private static final int GRP_AREA_MAX_BTNS = 30;
    private static final String DEFAULT_STYLE = "default-group";
    private final List<MenuButton> groupButtons;
    private final ButtonArea hotArea;
    private final ButtonArea groupArea;
    private final ButtonArea serviceArea;
    private final ButtonArea mixedArea;
    private final ButtonArea prevgroupArea;
    private final Set<String> styles = new HashSet<String>();
    private SButton grpPrev;
    private SButton grpNext;
    @FXML
    private GridPane realGroupGrid;
    @FXML
    private GridPane containerGroupGrid;
    private int currGrpShift;
    private int currGrpBtnCount;

    public ShowcaseGroupMenuTemplate(String screenId) {
        super(screenId);
        this.styles.add("light");
        this.styles.add("dark");
        this.styles.add("black");
        this.styles.add("white");
        this.styles.add("default-prevgroup-pressed");
        this.groupButtons = new LinkedList<MenuButton>();
        this.hotArea = new VoidButtonArea();
        this.groupArea = new InfiniteButtonArea(inits -> {
            this.currGrpShift = 0;
            this.currGrpBtnCount = 0;
            this.grpPrev.setVisible(false);
            this.grpNext.setVisible(inits != null && inits.size() > 12);
            this.initMenuButtons(this.groupButtons, inits);
        });
        this.prevgroupArea = new InfiniteButtonArea(null);
        this.serviceArea = new InfiniteButtonArea(null);
        this.mixedArea = new InfiniteButtonArea(null);
    }

    public void init() throws FxInitException {
        super.init();
        this.fill(this.groupButtons, "group");
        this.grpPrev = this.searchButton("grpPrev", true);
        this.grpNext = this.searchButton("grpNext", true);
        this.grpPrev.setListener((ButtonListener)new LocalNaviListener("prev"));
        this.grpNext.setListener((ButtonListener)new LocalNaviListener("next"));
    }

    private void fill(List<MenuButton> list, String prefix) throws FxInitException {
        MenuButton mb;
        for (int i = 0; i < 30 && (mb = this.searchMenuButton(prefix + i, prefix)) != null; ++i) {
            list.add(mb);
        }
    }

    private void initMenuButtons(List<MenuButton> buttons, List<MenuButtonInit> inits) {
        this.setVisibleAllGroupButtons(false);
        if (inits != null) {
            for (int i = 0; i < buttons.size() && i < inits.size(); ++i) {
                MenuButtonInit mbi = inits.get(i);
                MenuButton mb = buttons.get(i);
                mb.setListener(mbi.getListener());
                mb.setLocked(mbi.isDisable());
                mb.resetStyles();
                if (this.styles.contains(mbi.getStyleClass())) {
                    mb.addStyleClass(mbi.getStyleClass());
                } else {
                    if (mbi.getStyleClass() != null && !mbi.getStyleClass().isEmpty()) {
                        GuiNotifier.notifyProblemOnce((String)("Button style " + mbi.getStyleClass() + " is not found"));
                    }
                    mb.addStyleClass(DEFAULT_STYLE);
                }
                String fullPath = mbi.getLogo() == null || mbi.getLogo().isEmpty() ? null : Locator.getPath((String)("/gui/skin/{name}/img/" + mbi.getLogo()));
                mb.setLogo(fullPath);
            }
            this.returnButtons();
            int minSize = Math.min(12, inits.size());
            this.placeButtons(minSize, 0, false, inits.size() > 12);
        }
    }

    private void setVisibleAllGroupButtons(boolean visible) {
        for (MenuButton mb : this.groupButtons) {
            mb.setVisible(visible);
        }
    }

    private void placeButtons(int bSize, int startIndex, boolean visiblePrev, boolean visibleNext) {
        this.currGrpBtnCount = 12;
        if (visiblePrev) {
            --this.currGrpBtnCount;
        }
        if (visibleNext) {
            --this.currGrpBtnCount;
        }
        if (bSize < this.currGrpBtnCount) {
            this.currGrpBtnCount = bSize;
        }
        int addBtn = 0;
        int btnIdx = 0;
        int shift = 0;
        int idxCorrection = 0;
        boolean end = false;
        for (int i = 0; i < 3; ++i) {
            if (shift == 1) {
                idxCorrection = -1;
            }
            shift = 0;
            int j = 0;
            while (j + shift < 4) {
                if (visiblePrev && i == 0) {
                    shift = 1;
                }
                btnIdx = startIndex + i * 4 + j + idxCorrection;
                this.placeButton(i, j + shift, btnIdx);
                this.groupButtons.get(btnIdx).setVisible(true);
                if (++addBtn >= this.currGrpBtnCount) {
                    end = true;
                    break;
                }
                ++j;
            }
            if (end) break;
        }
    }

    private void placeButton(int rowIdx, int columnIdx, int bNumber) {
        Node n = this.containerGroupGrid.lookup("#group" + bNumber);
        if (n != null) {
            this.containerGroupGrid.getChildren().remove((Object)n);
            this.realGroupGrid.add(n, columnIdx * 2, 1 + rowIdx * 2);
        }
    }

    private void returnButtons() {
        for (int i = 0; i < 30; ++i) {
            Node mb = this.realGroupGrid.lookup("#group" + i);
            if (mb == null) continue;
            this.realGroupGrid.getChildren().remove((Object)mb);
            this.containerGroupGrid.add(mb, 0, 0);
        }
    }

    public ButtonArea getHotArea() {
        return this.hotArea;
    }

    public ButtonArea getServiceArea() {
        return this.serviceArea;
    }

    public ButtonArea getGroupArea() {
        return this.groupArea;
    }

    public ButtonArea getMixedArea() {
        return this.mixedArea;
    }

    public ButtonArea getPrevGroupArea() {
        return this.prevgroupArea;
    }

    public void addUserStylesheet(String url) {
        this.styles.addAll(StyleExtractor.extractStyles((String)url));
        this.getPane().getStylesheets().add((Object)url);
    }

    public String toString() {
        return "ShowcaseGroupMenuTemplate{}";
    }

    private class LocalNaviListener
    implements ButtonListener {
        private final String actionType;

        public LocalNaviListener(String actionType) {
            this.actionType = actionType;
        }

        public void onAction() {
            if (ShowcaseGroupMenuTemplate.this.groupArea.getInits() != null) {
                if (ActionType.isNext((String)this.actionType)) {
                    ShowcaseGroupMenuTemplate.this.currGrpShift = ShowcaseGroupMenuTemplate.this.currGrpShift + ShowcaseGroupMenuTemplate.this.currGrpBtnCount;
                } else {
                    ShowcaseGroupMenuTemplate.this.currGrpShift = ShowcaseGroupMenuTemplate.this.currGrpShift - (ShowcaseGroupMenuTemplate.this.currGrpShift > 11 ? 10 : 11);
                }
                boolean visiblePrev = ShowcaseGroupMenuTemplate.this.currGrpShift > 0;
                boolean visibleNext = ShowcaseGroupMenuTemplate.this.currGrpShift + 12 - 1 < ShowcaseGroupMenuTemplate.this.groupArea.getInits().size();
                int bSize = ShowcaseGroupMenuTemplate.this.groupArea.getInits().size() - ShowcaseGroupMenuTemplate.this.currGrpShift;
                bSize = bSize > 12 ? 12 : bSize;
                ShowcaseGroupMenuTemplate.this.grpPrev.setVisible(visiblePrev);
                ShowcaseGroupMenuTemplate.this.grpNext.setVisible(visibleNext);
                ShowcaseGroupMenuTemplate.this.setVisibleAllGroupButtons(false);
                ShowcaseGroupMenuTemplate.this.returnButtons();
                ShowcaseGroupMenuTemplate.this.placeButtons(bSize, ShowcaseGroupMenuTemplate.this.currGrpShift, visiblePrev, visibleNext);
            }
        }
    }
}

