/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.table;

import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.text.Text;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.msg.MessageTemplate;
import plfx.msg.ScreenElement;
import plfx.msg.TableViewMessageTemplate;
import plfx.screen.input.table.DefaultTableTemplate;
import plfx.screen.input.table.TableTemplateListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.table.TableColumn;
import ru.softlogic.input.model.field.table.TableItem;

public class ShowcaseTableTemplate
extends DefaultTableTemplate {
    protected static int SCROLLSIZE = 61;
    private static int SCROLL_POS = 0;
    private static final int SCROLL_OFFSET = 9;
    @FXML
    private TableView<TableItem> tableView;
    private TableTemplateListener listener;
    private List<TableItem> items;
    private Boolean readonly;
    private List<TableColumn> columns;
    private SButton extScrollUpBtn;
    private SButton extScrollDwnBtn;

    public ShowcaseTableTemplate(String screenId) {
        super(screenId);
    }

    public void init() throws FxInitException {
        super.init();
        this.extScrollUpBtn = this.searchButton("scrollUpBtn");
        this.extScrollDwnBtn = this.searchButton("scrollDwnBtn");
        this.extScrollUpBtn.setDisable(true);
        this.extScrollDwnBtn.setDisable(true);
        this.extScrollUpBtn.setListener(() -> {
            if (SCROLL_POS > 0) {
                --SCROLL_POS;
            }
            this.updateScrollBtnState();
            this.scrollTableToCurrent();
        });
        this.extScrollDwnBtn.setListener(() -> {
            if (SCROLL_POS < this.tableView.getItems().size() - 9) {
                ++SCROLL_POS;
            }
            this.updateScrollBtnState();
            this.scrollTableToCurrent();
        });
        this.nextBtn.setListener(() -> {
            if (this.listener != null) {
                if (this.readonly.booleanValue()) {
                    this.listener.onSelect(this.items.get(0));
                } else {
                    this.listener.onSelect((TableItem)this.tableView.getSelectionModel().getSelectedItem());
                }
            }
        });
    }

    private void setButtonState(boolean active) {
        this.nextBtn.setDisable(!active);
    }

    public TableView<TableItem> getTableView() {
        return this.tableView;
    }

    private void scrollTableToCurrent() {
        this.tableView.scrollTo(SCROLL_POS);
    }

    private void updateScrollBtnState() {
        this.extScrollUpBtn.setDisable(SCROLL_POS <= 0);
        this.extScrollDwnBtn.setDisable(SCROLL_POS >= this.tableView.getItems().size() - 9);
    }

    public void setTable(List<TableColumn> columns, List<TableItem> items, Boolean readonly, TableTemplateListener listener, String emptyText) {
        this.columns = columns;
        this.items = items;
        this.listener = listener;
        this.readonly = readonly;
        SCROLL_POS = 0;
        this.getDynamicElements().clear();
        this.tableView.setMouseTransparent(readonly.booleanValue());
        this.setButtonState(readonly);
        this.tableView.getColumns().clear();
        if (emptyText != null) {
            this.tableView.setPlaceholder((Node)new Text(emptyText));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        LinkedList<javafx.scene.control.TableColumn> cols = new LinkedList<javafx.scene.control.TableColumn>();
        boolean isEvenColumn = true;
        for (TableColumn tc : this.columns) {
            javafx.scene.control.TableColumn col = new javafx.scene.control.TableColumn();
            if (isEvenColumn) {
                col.getStyleClass().add((Object)"column-even");
            } else {
                col.getStyleClass().add((Object)"column-odd");
            }
            boolean bl = isEvenColumn = !isEvenColumn;
            if (tc.getTitleid() != null) {
                this.getDynamicElements().add(new ScreenElement((MessageTemplate)new TableViewMessageTemplate(col, "$lu.get(\"" + tc.getTitleid() + "\")")));
            } else {
                col.setText(tc.getTitle());
            }
            String id = tc.getKey();
            col.prefWidthProperty().bind((ObservableValue)this.tableView.widthProperty().add(-SCROLLSIZE).multiply(tc.getWidth() / 100.0));
            col.setCellValueFactory(p -> {
                InputElement ie = (InputElement)((TableItem)p.getValue()).getElements().get(id);
                if (ie != null) {
                    if (ie.getValueTitle() != null) {
                        return new SimpleStringProperty(((InputElement)((TableItem)p.getValue()).getElements().get(id)).getValueTitle());
                    }
                    return new SimpleStringProperty(((InputElement)((TableItem)p.getValue()).getElements().get(id)).getValue());
                }
                return new SimpleStringProperty("");
            });
            cols.add(col);
        }
        ((javafx.scene.control.TableColumn)cols.get(0)).getStyleClass().add((Object)"column-first");
        this.tableView.getColumns().addAll(cols);
        this.tableView.setItems(data);
        this.updateScrollBtnState();
        this.scrollTableToCurrent();
        this.tableView.getSelectionModel().clearSelection();
    }
}

