/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.group;

import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import plfx.msg.MessageTemplate;
import plfx.msg.SupplierMessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.input.group.InputComponentListener;
import plfx.screen.input.group.SelectorInputComponent;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;

public class ShowcaseSelectorInputComponent
extends SelectorInputComponent {
    protected Label title;
    protected Pane icon;
    protected boolean titleSet;
    protected boolean example;

    public ShowcaseSelectorInputComponent(ComboBox<String> component, Label title, Pane icon, SelectorField field, Object value, InputComponentListener listener, int index) {
        super(component, field, value, listener, index);
        this.title = title;
        this.icon = icon;
        title.getStyleClass().add((Object)"element-title");
        icon.getStyleClass().add((Object)"element-icon");
        InputElement ie = null;
        if (value != null && value instanceof InputElement) {
            ie = (InputElement)value;
        }
        int select = -1;
        component.getItems().clear();
        for (int i = 0; i < field.getItems().size(); ++i) {
            SelectorItem si = (SelectorItem)field.getItems().get(i);
            if (si.getTitleId() != null && !si.getTitleId().isEmpty()) {
                ScreenProcessor.process((String)"skin", (MessageTemplate)new SupplierMessageTemplate("$lu.get(\"" + si.getTitleId() + "\")", arg_0 -> component.getItems().add(arg_0)));
            } else {
                component.getItems().add((Object)si.getTitle());
            }
            if (ie == null || ie.getValue() == null || !ie.getValue().equals(si.getValue()) || ie.getValueTitle() == null || !ie.getValueTitle().equals(si.getTitle())) continue;
            select = i;
        }
        if (select >= 0) {
            component.getSelectionModel().select(select);
        } else if (field.getSelectedIndex() != null && field.getSelectedIndex() < component.getItems().size()) {
            component.getSelectionModel().select(field.getSelectedIndex().intValue());
        } else {
            component.getSelectionModel().clearSelection();
        }
        String fTitle = field.getTitle();
        if (fTitle == null || fTitle.trim().isEmpty()) {
            this.titleSet = false;
            title.setText("");
        } else {
            this.titleSet = true;
            title.setText(fTitle);
        }
        title.setVisible(this.titleSet);
        this.updateStyle();
    }

    public String toString() {
        return "ShowcaseSelectorInputComponent{field=" + this.field + '}';
    }

    private void updateStyle() {
        this.component.getStyleClass().remove((Object)"element-combobox-selected");
        this.component.getStyleClass().remove((Object)"element-combobox-error");
        this.component.getStyleClass().remove((Object)"element-label-corner");
        this.component.getStyleClass().remove((Object)"element-label-corner-error");
        this.component.getStyleClass().remove((Object)"element-label-example");
        this.title.getStyleClass().remove((Object)"element-title-error");
        this.icon.getStyleClass().remove((Object)"element-icon-valid");
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-combobox-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-combobox-error");
            this.title.getStyleClass().add((Object)"element-title-error");
            if (this.titleSet) {
                this.component.getStyleClass().add((Object)"element-label-corner-error");
            }
        } else if (this.titleSet) {
            this.component.getStyleClass().add((Object)"element-label-corner");
        }
        if (this.valid) {
            this.icon.getStyleClass().add((Object)"element-icon-valid");
        }
        if (this.example) {
            this.component.getStyleClass().add((Object)"element-label-example");
        }
    }
}

