/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.group;

import java.util.LinkedList;
import java.util.Map;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import plfx.element.TitledArea;
import plfx.element.UpDownLable;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.model.action.ActionNotifier;
import plfx.screen.Screen;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.group.CheckBoxInputComponent;
import plfx.screen.input.group.GroupScreen;
import plfx.screen.input.group.GroupTemplate;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.numeric.ComplexKeyboardListener;
import plfx.showcase.screen.input.group.ShowcaseAutoCompleteInputComponent;
import plfx.showcase.screen.input.group.ShowcaseDateInputComponent;
import plfx.showcase.screen.input.group.ShowcaseGroupTemplate;
import plfx.showcase.screen.input.group.ShowcaseNumericInputComponent;
import plfx.showcase.screen.input.group.ShowcaseSelectorInputComponent;
import plfx.showcase.screen.input.group.ShowcaseTextInputComponent;
import plfx.showcase.screen.input.group.ShowcaseValidActionNotifier;
import ru.softlogic.input.model.field.Field;
import ru.softlogic.input.model.field.FieldType;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;
import ru.softlogic.input.model.field.date.DateField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;

public class ShowcaseGroupScreen2
extends GroupScreen {
    private final ShowcaseGroupTemplate scTpl;
    private final ShowcaseValidActionNotifier keyboardNotifier;

    public ShowcaseGroupScreen2(ShowcaseGroupTemplate tpl, Map<String, Layout> layouts) {
        super((GroupTemplate)tpl, layouts);
        this.scTpl = tpl;
        this.keyboardNotifier = new ShowcaseValidActionNotifier((Screen)this);
        this.keyboardListener = new ComplexKeyboardListener((ActionNotifier)this.keyboardNotifier);
        if (this.letterKeyboard != null) {
            this.letterKeyboard.setKeyboardListener((KeyboardListener)this.keyboardListener);
        }
    }

    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        if (!sd.getType().contains("letter") && !sd.getType().contains("group")) {
            throw new InitException("Wrong screen type, have " + sd.getType() + ", must be group or letter");
        }
        this.scTpl.initButtons(sd.getButtons());
        if (sd.getSequence() == null || sd.getSequence().getFields() == null || sd.getSequence().getFields().isEmpty()) {
            throw new InitException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f");
        }
        if (sd.getSequence().getFields().size() > this.scTpl.getTitledAreas().size()) {
            throw new InitException("Too many fields, count=" + sd.getSequence().getFields().size() + ", capacity=" + this.scTpl.getTitledAreas().size());
        }
        String focusedField = null;
        if (sd instanceof UniScreenDescription) {
            UniScreenDescription usd = (UniScreenDescription)sd;
            focusedField = usd.getFocusedField();
        }
        for (TitledArea ta : this.scTpl.getTitledAreas()) {
            ta.setVisible(false);
        }
        for (Label l : this.scTpl.getExampleLabels()) {
            l.setVisible(false);
        }
        for (Pane p : this.scTpl.getSuccessIcons()) {
            p.setVisible(false);
        }
        this.components = new LinkedList();
        Object focusedComp = null;
        Map d = si.getModelEnvironment().getData();
        this.fields = sd.getSequence().initFields(si.getModelEnvironment());
        int i = 0;
        for (Field f : this.fields) {
            Label label;
            TextField field;
            if (f.isExist() && !d.containsKey(f.getId())) continue;
            Object value = d.get(f.getId());
            TitledArea ta = (TitledArea)this.scTpl.getTitledAreas().get(i);
            ta.setVisible(true);
            Pane sIcon = this.scTpl.getSuccessIcons().get(i);
            sIcon.setVisible(true);
            Label example = this.scTpl.getExampleLabels().get(i);
            example.setVisible(true);
            Object component = null;
            if (f.getType() == FieldType.Letter) {
                field = (TextField)f;
                label = new Label();
                component = new ShowcaseTextInputComponent(label, example, sIcon, field, value, this.createFL(), i);
                ta.setControl((Control)label);
                ta.setTitle(field.getTitle() + ":");
            } else if (f.getType() == FieldType.Numeric) {
                field = (NumericField)f;
                UpDownLable udl = new UpDownLable(Math.abs(field.getUpdown()) > 0.01);
                component = new ShowcaseNumericInputComponent(udl, example, sIcon, (NumericField)field, value, this.createFL(), i);
                ta.setControl((Control)udl);
                ta.setTitle(field.getTitle() + ":");
            } else if (f.getType() == FieldType.Selector) {
                field = (SelectorField)f;
                ComboBox cb = new ComboBox();
                component = new ShowcaseSelectorInputComponent((ComboBox<String>)cb, example, sIcon, (SelectorField)field, value, this.createFL(), i);
                cb.setVisibleRowCount(5);
                ta.setControl((Control)cb);
                ta.setTitle(field.getTitle() + ":");
            } else if (f.getType() == FieldType.Date) {
                field = (DateField)f;
                label = new Label();
                component = new ShowcaseDateInputComponent(label, example, sIcon, (DateField)field, value, this.createFL(), i);
                ta.setControl((Control)label);
                ta.setTitle(field.getTitle() + ":");
            } else if (f.getType() == FieldType.AutoComplete) {
                field = (AutoCompleteField)f;
                label = new Label();
                component = new ShowcaseAutoCompleteInputComponent(label, example, sIcon, (AutoCompleteField)field, value, this.createFL(), i);
                ta.setControl((Control)label);
                ta.setTitle(field.getTitle() + ":");
            } else if (f.getType() == FieldType.CheckBox) {
                field = (CheckBoxField)f;
                label = new Label();
                component = new CheckBoxInputComponent(label, (CheckBoxField)field, value, this.createFL(), i);
                ta.setControl((Control)label);
                ta.setTitle(field.getTitle() + ":");
            }
            this.components.add(component);
            if (f.getId().equals(focusedField)) {
                focusedComp = component;
            }
            ++i;
        }
        this.notifier.init();
        this.notifier.setComponents(this.components);
        this.keyboardNotifier.init();
        this.keyboardNotifier.setComponents(this.components);
        this.skipPopup = true;
        if (!this.components.isEmpty()) {
            if (focusedComp != null) {
                focusedComp.getFocus();
            } else {
                ((InputComponent)this.components.get(0)).getFocus();
            }
            this.processNext();
        }
        this.scTpl.setServiceLogo(sd.getIcon(), sd.getStyleClass());
        if (this.scTpl.getNavigation() != null) {
            this.scTpl.getNavigation().init(sd.getNavigations(), (ActionNotifier)this.notifier);
        }
    }

    public void setListener(ScreenListener listener) {
        super.setListener(listener);
        this.keyboardNotifier.setListener(listener);
    }
}

