/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.group;

import java.util.Map;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import plfx.element.TitledArea;
import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.letter.Layout;
import plfx.model.action.ActionNotifier;
import plfx.screen.Screen;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.input.group.GroupScreen;
import plfx.screen.input.group.GroupTemplate;
import plfx.screen.input.group.InputComponent;
import plfx.screen.input.group.InputComponentListener;
import plfx.screen.input.numeric.ComplexKeyboardListener;
import plfx.showcase.screen.input.group.ShowcaseAutoCompleteInputComponent;
import plfx.showcase.screen.input.group.ShowcaseValidActionNotifier;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class ShowcaseGroupScreen
extends GroupScreen {
    private final ShowcaseValidActionNotifier keyboardNotifier = new ShowcaseValidActionNotifier((Screen)this);

    public ShowcaseGroupScreen(GroupTemplate tpl, Map<String, Layout> layouts) {
        super(tpl, layouts);
        this.keyboardListener = new ComplexKeyboardListener((ActionNotifier)this.keyboardNotifier);
        if (this.letterKeyboard != null) {
            this.letterKeyboard.setKeyboardListener((KeyboardListener)this.keyboardListener);
        }
    }

    protected void _init(ScreenDescription sd, ScreenInit si) throws InitException {
        super._init(sd, si);
        this.keyboardNotifier.init();
        this.keyboardNotifier.setComponents(this.components);
    }

    public void setListener(ScreenListener listener) {
        super.setListener(listener);
        this.keyboardNotifier.setListener(listener);
    }

    protected InputComponent createField(AutoCompleteField field, TitledArea ta, Object value, InputComponentListener l, int i) {
        Label label = new Label();
        ta.setControl((Control)label);
        ta.setTitle(field.getTitle() + ":");
        return new ShowcaseAutoCompleteInputComponent(label, new Label(), new Pane(), field, value, l, i);
    }
}

