/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.group;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.input.keyboard.letter.LayoutLoader;
import plfx.screen.CommonScreen;
import plfx.screen.CommonScreenFactory;
import plfx.screen.ScreenCreateException;
import plfx.showcase.screen.input.group.ShowcaseGroupScreen2;
import plfx.showcase.screen.input.group.ShowcaseGroupTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class ShowcaseGroupFactory
implements CommonScreenFactory {
    public CommonScreen create(String path, Properties prop) throws ScreenCreateException {
        try {
            Map layouts;
            try {
                layouts = LayoutLoader.readLayouts((String)("/screen/pay/" + path + "/layout.properties"), (Properties)prop);
            }
            catch (FxInitException ex) {
                layouts = LayoutLoader.readLayouts((String)"/layout/default.properties", (Properties)prop);
            }
            ShowcaseGroupTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class, String.class);
                    template = (ShowcaseGroupTemplate)((Object)c.newInstance("screen.pay." + path, path.startsWith("@") ? "ext" : "skin"));
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                    template = new ShowcaseGroupTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
                }
            } else {
                template = new ShowcaseGroupTemplate("screen.pay." + path, path.startsWith("@") ? "ext" : "skin");
            }
            if (path.startsWith("@")) {
                ResourceLoader.load((URL)Locator.getUrl((String)("/gui/system/screen/" + path.substring(1) + "/template.fxml")), (Object)((Object)template));
            } else {
                ResourceLoader.load((URL)Locator.getUrl((String)("/gui/skin/{name}//screen/pay/" + path + "/template.fxml")), (Object)((Object)template));
            }
            template.init();
            ShowcaseGroupScreen2 screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(ShowcaseGroupTemplate.class, Map.class);
                    screen = (CommonScreen)c.newInstance(new Object[]{template, layouts});
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError((Throwable)throwable);
                    screen = new ShowcaseGroupScreen2(template, layouts);
                }
            } else {
                screen = new ShowcaseGroupScreen2(template, layouts);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            throw new ScreenCreateException("Erron on create group screen: " + path, ex);
        }
    }
}

