/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.group;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.layout.Pane;
import javafx.stage.Popup;
import javafx.stage.Window;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.InputFieldModel;
import plfx.screen.input.group.AutoCompleteInputComponent;
import plfx.screen.input.group.InputComponentListener;
import plfx.skin.Skin;
import plfx.util.Locator;
import plfx.util.TerminalPlatform;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;

public class ShowcaseAutoCompleteInputComponent
extends AutoCompleteInputComponent {
    protected Label title;
    protected Pane icon;
    protected boolean titleSet;
    protected boolean example;
    private final AutoCompletePopup autoCompletePopup;

    public ShowcaseAutoCompleteInputComponent(Label component, Label title, Pane icon, final AutoCompleteField field, Object oValue, InputComponentListener listener, int index) {
        super(component, field, oValue, listener, index, null);
        this.title = title;
        this.icon = icon;
        this.index = index;
        title.getStyleClass().add((Object)"element-title");
        icon.getStyleClass().add((Object)"element-icon");
        this.autoCompletePopup = new AutoCompletePopup(component);
        this.model = new AutoCompleteModel();
        this.model.addListener(new FieldListener(){

            public void onChange(String value) {
                if (ShowcaseAutoCompleteInputComponent.this.completed || field.isAllowCustom() && !value.isEmpty()) {
                    ShowcaseAutoCompleteInputComponent.this.component.setText(value);
                    ShowcaseAutoCompleteInputComponent.this.completed = false;
                    if (field.isAllowCustom()) {
                        ShowcaseAutoCompleteInputComponent.this.complete = new InputElement(field.getId(), field.getTitle(), value);
                        ShowcaseAutoCompleteInputComponent.this.valid = true;
                        ShowcaseAutoCompleteInputComponent.this.listener.onChange();
                    }
                } else {
                    ShowcaseAutoCompleteInputComponent.this.complete = null;
                    ShowcaseAutoCompleteInputComponent.this.component.setText(value);
                    ShowcaseAutoCompleteInputComponent.this.listener.onChange();
                }
                ShowcaseAutoCompleteInputComponent.this.processExample();
                ShowcaseAutoCompleteInputComponent.this.updateStyle();
            }

            public void onEnter(String value) {
            }
        });
        this.model.setValue("");
        if (oValue instanceof InputElement) {
            InputElement ie;
            this.complete = ie = (InputElement)oValue;
            this.completed = true;
            this.model.setValue(this.complete.getValueTitle());
        } else {
            InputElement def = field.getDataStore().getDefaultElement();
            if (def != null) {
                this.complete = def;
                this.completed = true;
                this.model.setValue(this.complete.getValueTitle());
            }
        }
        component.textProperty().addListener((ChangeListener)new AutoCompleteListener());
        String fTitle = field.getTitle();
        if (fTitle == null || fTitle.trim().isEmpty()) {
            this.titleSet = false;
            title.setText("");
        } else {
            this.titleSet = true;
            title.setText(fTitle);
        }
        title.setVisible(this.titleSet);
        this.processExample();
        this.updateStyle();
    }

    public boolean isValid() {
        this.valid = this.complete != null || this.model.getValue().isEmpty() && this.field.isOptional();
        this.setWarning(!this.model.getValue().isEmpty() && !this.valid && !this.selected);
        return this.valid;
    }

    public String toString() {
        return "ShowcaseAutoCompleteInputComponent{field=" + this.field + '}';
    }

    private void updateStyle() {
        while (this.component.getStyleClass().remove((Object)"element-label-selected")) {
        }
        while (this.component.getStyleClass().remove((Object)"element-label-corner")) {
        }
        while (this.component.getStyleClass().remove((Object)"element-label-error")) {
        }
        while (this.component.getStyleClass().remove((Object)"element-label-corner-error")) {
        }
        while (this.component.getStyleClass().remove((Object)"element-label-example")) {
        }
        while (this.title.getStyleClass().remove((Object)"element-title-error")) {
        }
        while (this.icon.getStyleClass().remove((Object)"element-icon-valid")) {
        }
        if (this.selected) {
            this.component.getStyleClass().add((Object)"element-label-selected");
        }
        if (this.warning) {
            this.component.getStyleClass().add((Object)"element-label-error");
            this.title.getStyleClass().add((Object)"element-title-error");
            if (this.titleSet) {
                this.component.getStyleClass().add((Object)"element-label-corner-error");
            }
        } else if (this.titleSet) {
            this.component.getStyleClass().add((Object)"element-label-corner");
        }
        if (this.valid) {
            this.icon.getStyleClass().add((Object)"element-icon-valid");
        }
        if (this.example) {
            this.component.getStyleClass().add((Object)"element-label-example");
        }
    }

    private void processExample() {
        String exampleValue = this.field.getExampleValue();
        String value = this.model.getValue();
        if (exampleValue != null && !exampleValue.isEmpty() && (value == null || value.isEmpty())) {
            this.example = true;
            this.component.setText(exampleValue);
        } else {
            this.example = false;
        }
    }

    private static class AutoCompleteModel
    implements InputFieldModel {
        private String value;
        private final Set<FieldListener> listeners = new LinkedHashSet<FieldListener>();

        public void add(char ch) {
            this._add(ch, true);
        }

        public void clear() {
            this.value = "";
            this.notifyListeners();
        }

        public void clearLast() {
            if (this.value.length() > 0) {
                this.value = this.value.substring(0, this.value.length() - 1);
                this.notifyListeners();
            } else {
                this.value = "";
                this.notifyListeners();
            }
        }

        public void setValue(String value) {
            this.value = "";
            if (value != null && !value.isEmpty()) {
                for (char ch : value.toCharArray()) {
                    this._add(ch, false);
                }
                this.notifyListeners();
            }
        }

        public String getValue() {
            return this.value;
        }

        public String getClearValue() {
            return this.value;
        }

        public void addListener(FieldListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        private void notifyListeners() {
            for (FieldListener fl : this.listeners) {
                fl.onChange(this.getValue());
            }
        }

        private void _add(char ch, boolean doNotify) {
            this.value = this.value + ch;
            if (doNotify) {
                this.notifyListeners();
            }
        }

        public void enter() {
            for (FieldListener fl : this.listeners) {
                fl.onEnter(this.getValue());
            }
        }
    }

    private class AutoCompletePopup {
        private Popup popup;
        private ListView<String> listView;
        private final Label label;
        private Thread timeout;
        private List<InputElement> list;
        private String styleSuffix;
        private double popupWidth;
        private double indent;

        public AutoCompletePopup(Label label) {
            this.label = label;
            this.popup = new Popup();
            this.popup.setAutoHide(true);
            this.popup.setConsumeAutoHidingEvents(false);
            this.styleSuffix = ShowcaseAutoCompleteInputComponent.this.index > 3 ? "-bottom" : (ShowcaseAutoCompleteInputComponent.this.index == 3 ? "-right" : (ShowcaseAutoCompleteInputComponent.this.index == 2 ? "-left" : "-top"));
            this.popup.showingProperty().addListener((o, ov, nv) -> {
                if (nv.booleanValue()) {
                    ShowcaseAutoCompleteInputComponent.this.component.getStyleClass().add((Object)("autocomplete-label-showing" + this.styleSuffix));
                } else {
                    ShowcaseAutoCompleteInputComponent.this.component.getStyleClass().removeAll((Object[])new String[]{"autocomplete-label-showing" + this.styleSuffix});
                }
            });
            this.listView = new ListView();
            this.listView.getStyleClass().add((Object)"autocomplete-popup");
            this.listView.getStyleClass().add((Object)("autocomplete-popup" + this.styleSuffix));
            this.listView.getStyleClass().add((Object)"base-panel");
            Optional.ofNullable(Locator.getFileUrl((String)"/gui/skin/{name}/system/colorscheme.css")).ifPresent(css -> this.listView.getStylesheets().add((Object)css.toExternalForm()));
            Optional.ofNullable(Locator.getFileUrl((String)("/gui/skin/{name}/system/" + Skin.getWorkScreenSizeName() + ".css"))).ifPresent(css -> this.listView.getStylesheets().add((Object)css.toExternalForm()));
            this.popupWidth = 0.0;
            this.indent = 0.0;
            String[] sizes = Skin.getWorkScreenSizeName().split("x");
            if (sizes.length == 2) {
                try {
                    int width = Integer.parseInt(sizes[0]);
                    this.indent = Math.round((double)width * 0.0171);
                    if (ShowcaseAutoCompleteInputComponent.this.index == 2) {
                        this.popupWidth = Math.round((double)width * 0.3742);
                    } else if (ShowcaseAutoCompleteInputComponent.this.index == 3) {
                        this.popupWidth = Math.round((double)width * 0.3421);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.popup.getContent().add(this.listView);
            this.listView.setOnMouseClicked(t -> {
                MultipleSelectionModel selection = this.listView.getSelectionModel();
                if (selection.getSelectedIndex() >= 0 && selection.getSelectedItem() != null && this.list != null) {
                    ShowcaseAutoCompleteInputComponent.this.complete = this.list.get(selection.getSelectedIndex());
                }
                if (ShowcaseAutoCompleteInputComponent.this.complete != null) {
                    ShowcaseAutoCompleteInputComponent.this.completed = true;
                    ShowcaseAutoCompleteInputComponent.this.model.setValue(ShowcaseAutoCompleteInputComponent.this.complete.getValueTitle());
                    ShowcaseAutoCompleteInputComponent.this.listener.onChange();
                    this.popup.hide();
                }
            });
        }

        public void show(List<InputElement> list) {
            double currentWidth;
            this.list = list;
            this.popup.hide();
            if (this.timeout != null && this.timeout.isAlive()) {
                this.timeout.interrupt();
            }
            this.timeout = new Thread(() -> {
                try {
                    Thread.sleep(30000L);
                    TerminalPlatform.runLater(() -> this.popup.hide());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            this.listView.getItems().clear();
            list.stream().forEach(ie -> this.listView.getItems().add((Object)ie.getValueTitle()));
            int min = list.size() > 5 ? 5 : list.size();
            double listViewHeight = this.label.getHeight() * (double)min / 2.0 + (double)(6 * min);
            this.listView.setPrefHeight(listViewHeight);
            if (this.popupWidth == 0.0) {
                this.indent = 0.0;
                currentWidth = this.label.getWidth();
            } else {
                currentWidth = this.popupWidth;
            }
            this.listView.setPrefWidth(currentWidth);
            this.timeout.start();
            if (this.label.getScene() != null) {
                double popupY;
                double popupX;
                Window w = this.label.getScene().getWindow();
                if (ShowcaseAutoCompleteInputComponent.this.index > 3) {
                    popupX = w.getX() + this.label.localToScene(0.0, 0.0).getX() + this.label.getScene().getX();
                    popupY = w.getY() + this.label.localToScene(0.0, 0.0).getY() + this.label.getScene().getY() - listViewHeight;
                } else if (ShowcaseAutoCompleteInputComponent.this.index == 3) {
                    popupX = w.getX() + this.label.localToScene(0.0, 0.0).getX() + this.label.getScene().getX() - currentWidth - this.indent;
                    popupY = w.getY() + this.label.localToScene(0.0, 0.0).getY() + this.label.getScene().getY() - listViewHeight / 2.0 + this.label.getHeight() / 2.0;
                } else if (ShowcaseAutoCompleteInputComponent.this.index == 2) {
                    popupX = w.getX() + this.label.localToScene(0.0, 0.0).getX() + this.label.getScene().getX() + this.label.getWidth() + this.indent;
                    popupY = w.getY() + this.label.localToScene(0.0, 0.0).getY() + this.label.getScene().getY() - listViewHeight / 2.0 + this.label.getHeight() / 2.0;
                } else {
                    popupX = w.getX() + this.label.localToScene(0.0, 0.0).getX() + this.label.getScene().getX();
                    popupY = w.getY() + this.label.localToScene(0.0, 0.0).getY() + this.label.getScene().getY() + this.label.getHeight();
                }
                this.popup.show(w, popupX, popupY);
            }
        }
    }

    private class AutoCompleteListener
    implements ChangeListener<String> {
        private AutoCompleteListener() {
        }

        public void changed(ObservableValue<? extends String> ov, String t, String value) {
            if (!ShowcaseAutoCompleteInputComponent.this.example && value != null && !value.isEmpty() && value.length() >= ShowcaseAutoCompleteInputComponent.this.field.getMinChars()) {
                List result = ShowcaseAutoCompleteInputComponent.this.field.getDataStore().getElements(value, ShowcaseAutoCompleteInputComponent.this.field.getMaxItems());
                if (ShowcaseAutoCompleteInputComponent.this.complete != null) {
                    result.remove(ShowcaseAutoCompleteInputComponent.this.complete);
                }
                if (result.size() > 0 && result.size() <= ShowcaseAutoCompleteInputComponent.this.field.getMaxItems()) {
                    ShowcaseAutoCompleteInputComponent.this.autoCompletePopup.show(result);
                }
            }
        }
    }
}

