/*
 * Decompiled with CFR 0.152.
 */
package plfx.showcase.screen.input.date;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.Button;
import plfx.element.SLabel;
import plfx.input.keyboard.KeyboardMessageTemplate;
import plfx.msg.MessageTemplate;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.input.date.DateSButton;

public class ShowcaseCalendarComponent {
    private static final String STYLE_SELECT = "calendar-day-selected";
    private static final String STYLE_NOT_SELECT = "calendar-day";
    private final SLabel month;
    private final SLabel year;
    private final SLabel[] daysOfWeek;
    private final DateSButton[][] days;
    private final ObjectProperty<Date> selectDate;
    private final String bundleId;
    private Date minDate;
    private Date maxDate;
    private int currentMonth;
    private int currentYear;
    private Calendar calendar;
    private SimpleDateFormat dayFormat;
    private Button lastSelect;
    private Button mPrev;
    private Button mNext;
    private Button yPrev;
    private Button yNext;

    public ShowcaseCalendarComponent(Button mPrev, Button mNext, Button yPrev, Button yNext, SLabel month, SLabel year, DateSButton[][] days, SLabel[] daysOfWeek, String bundleId, ChangeListener<Date> listener) {
        if (days == null) {
            throw new IllegalStateException("Days array is not set");
        }
        this.mPrev = mPrev;
        this.mNext = mNext;
        this.yPrev = yPrev;
        this.yNext = yNext;
        this.days = (DateSButton[][])days.clone();
        this.month = month;
        this.year = year;
        this.daysOfWeek = daysOfWeek;
        this.selectDate = new SimpleObjectProperty();
        this.selectDate.addListener(listener);
        this.bundleId = bundleId;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                DateSButton db = days[i][j];
                db.getButton().setOnMouseClicked(t -> {
                    this.setSelect(db.getButton());
                    this.selectDate.setValue((Object)db.getDate());
                });
            }
        }
        mNext.setOnMouseClicked(t -> this.nextMonth());
        mPrev.setOnMouseClicked(t -> this.prevMonth());
        yNext.setOnMouseClicked(t -> this.nextYear());
        yPrev.setOnMouseClicked(t -> this.prevYear());
    }

    public void init(Date minDate, Date maxDate, Date select, Locale locale) {
        this.minDate = minDate;
        this.maxDate = maxDate;
        if (select != null) {
            this.selectDate.setValue((Object)new Date(select.getTime()));
        }
        this.calendar = Calendar.getInstance(locale);
        this.calendar.setTime(select != null ? new Date(select.getTime()) : new Date());
        this.currentMonth = this.calendar.get(2);
        this.currentYear = this.calendar.get(1);
        this.dayFormat = new SimpleDateFormat("d");
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        for (int i = 0; i < 6; ++i) {
            this.daysOfWeek[i].setText(dfs.getShortWeekdays()[i + 2]);
        }
        this.daysOfWeek[6].setText(dfs.getShortWeekdays()[1]);
        this.rebuild();
    }

    public Date getSelectDate() {
        return (Date)this.selectDate.getValue();
    }

    private void clearDaysStyles() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.days[i][j].getButton().getStyleClass().removeAll((Object[])new String[]{STYLE_SELECT});
                this.days[i][j].getButton().getStyleClass().removeAll((Object[])new String[]{STYLE_NOT_SELECT});
                this.days[i][j].getButton().getStyleClass().add((Object)STYLE_NOT_SELECT);
            }
        }
        this.lastSelect = null;
    }

    private void setSelect(Button db) {
        if (this.lastSelect != null) {
            this.lastSelect.getStyleClass().removeAll((Object[])new String[]{STYLE_SELECT});
            this.lastSelect.getStyleClass().removeAll((Object[])new String[]{STYLE_NOT_SELECT});
            this.lastSelect.getStyleClass().add((Object)STYLE_NOT_SELECT);
        }
        db.getStyleClass().add((Object)STYLE_SELECT);
        this.lastSelect = db;
    }

    private void setButtonSkin(DateSButton db) {
        if (db.getDate() == null) {
            db.getButton().setText("");
            db.getButton().setDisable(true);
        } else if (this.isNotInInerval(db.getDate())) {
            db.getButton().setText(this.dayFormat.format(db.getDate()));
            db.getButton().setDisable(true);
        } else {
            db.getButton().setText(this.dayFormat.format(db.getDate()));
            db.getButton().setDisable(false);
            if (db.getDate().equals(this.selectDate.getValue())) {
                this.setSelect(db.getButton());
            }
        }
    }

    private boolean isNotInInerval(Date d) {
        if (this.minDate != null && d.compareTo(this.minDate) < 0) {
            return true;
        }
        return this.maxDate != null && d.compareTo(this.maxDate) > 0;
    }

    private void nextMonth() {
        this.calendar.add(2, 1);
        this.currentMonth = this.calendar.get(2);
        this.rebuild();
    }

    private void prevMonth() {
        this.calendar.add(2, -1);
        this.currentMonth = this.calendar.get(2);
        this.rebuild();
    }

    private void nextYear() {
        this.calendar.add(1, 1);
        this.currentYear = this.calendar.get(1);
        this.rebuild();
    }

    private void prevYear() {
        this.calendar.add(1, -1);
        this.currentYear = this.calendar.get(1);
        this.rebuild();
    }

    public int getCurrentMonth() {
        return this.currentMonth;
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    private void rebuild() {
        int j;
        int i;
        if (this.calendar == null) {
            throw new IllegalStateException("Calendar is not set");
        }
        if (this.days == null) {
            throw new IllegalStateException("Days array is not set");
        }
        KeyboardMessageTemplate kmt = new KeyboardMessageTemplate("calendar_month" + this.currentMonth);
        ScreenProcessor.process((String)this.bundleId, (MessageTemplate)kmt);
        this.month.setText(kmt.getValue());
        this.year.setText(Integer.toString(this.calendar.get(1)));
        int prev = this.currentMonth > 0 ? this.currentMonth - 1 : 11;
        int next = this.currentMonth < 11 ? this.currentMonth + 1 : 0;
        kmt = new KeyboardMessageTemplate("calendar_month" + prev);
        ScreenProcessor.process((String)this.bundleId, (MessageTemplate)kmt);
        this.mPrev.setText(kmt.getValue());
        kmt = new KeyboardMessageTemplate("calendar_month" + next);
        ScreenProcessor.process((String)this.bundleId, (MessageTemplate)kmt);
        this.mNext.setText(kmt.getValue());
        this.yPrev.setText(Integer.toString(this.calendar.get(1) - 1));
        this.yNext.setText(Integer.toString(this.calendar.get(1) + 1));
        this.clearDaysStyles();
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j2 = 0; j2 < 7; ++j2) {
                this.days[i2][j2].setDate(null);
            }
        }
        this.calendar.set(5, 1);
        int weekday = this.calendar.get(7) - 2;
        if (weekday < 0) {
            weekday = 6;
        }
        int countAdd = 0;
        int maxDays = this.calendar.getActualMaximum(5);
        for (i = 0; i < 7; ++i) {
            if (i < weekday) continue;
            this.days[0][i].setDate(this.calendar.getTime());
            ++countAdd;
            this.calendar.add(5, 1);
        }
        for (i = 1; i < 6; ++i) {
            for (j = 0; j < 7; ++j) {
                if (countAdd >= maxDays) continue;
                this.days[i][j].setDate(this.calendar.getTime());
                if (++countAdd >= maxDays) continue;
                this.calendar.add(5, 1);
            }
        }
        for (i = 0; i < 6; ++i) {
            for (j = 0; j < 7; ++j) {
                this.setButtonSkin(this.days[i][j]);
            }
        }
    }
}

